#!/usr/bin/perl -w
#plot_qrna2.pl

use strict;

use vars qw ($opt_a $opt_c $opt_d $opt_e $opt_i $opt_j $opt_I $opt_J $opt_g $opt_l $opt_m $opt_n $opt_o $opt_p $opt_s $opt_t $opt_T $opt_S $opt_u $opt_w $opt_y $opt_Y);
use Getopt::Std;
use constant GNUPLOT => '/usr/bin/gnuplot';   
#use constant GNUPLOT => '/usr/local/bin/gnuplot';  

getopts ('a:fc:d:e:i:j:I:J:g:l:m:n:o:p:s:t:T:S;u:w:y:Y:');     

if (!@ARGV) { 
    print "usage: plot_qrna2.pl [options] qrnafile qrnafilesh\n";
    print "options:\n";
    print "-c <case>            :  cases (default is case = 1)\n";
    print "                           possible cases are:\n";
    print "                           0=GLOBAL\n";  
    print "                           1=LOCAL_DIAG_VITERBI 2=LOCAL_DIAG_FORWARD\n";
    print "                           3=LOCAL_SEMI_VITERBI 4=LOCAL_SEMI_FORWARD\n";
    print "                           5=LOCAL_FULL_VITERBI 6=LOCAL_FULL_FORWARD\n";
    print "-a <max_n_ali>       : max number of alignments                [default all]\n";
    print "-d <divide_lodsc>    : for fits, lodsc for break of behaviour   [default divide_lodsc = 0]\n";
    print "-e <evalue>          : fit to an e-value\n";
    print "-i <min_id_plot>     : for ID plots                             [default min_id_plot = 50]\n";
    print "-j <max_id_plot>     : for ID plots                             [default max_id_plot = 100]\n";
    print "-I <min_id>          : min ID for analysis                      [default min_id = 0]\n";
    print "-J <max_id>          : max ID for analysis                      [default max_id = 100]\n";
    print "-g <max_gap_plot>    : for GAP plots                            [default max_gap_plot = 50]\n";
    print "-l <max_num_win>     : max number of windows to be considered   [default all]\n";
    print "-m <max_mut_plot>    : for MUT plots                            [default max_mut_plot = 50]\n";
    print "-n <time increments> : for TIME histo                           [default inc_t = 0.001]\n";
    print "-o <outfile>         : outfile                                  [default = qrnafile.timeplot]\n";
    print "-p <paramfile>       : paramfile                                [default = none]\n";
    print "-s <type_of_score>   : type of score (sigmoidal | simple)       [default = sigmoidal]\n";
    print "-t <max_time_plot>   : for plots                                [default max_time_plot = 0.8]\n";
    print "-T <max_time>        : max time for analysis                    [default max_time = 0.8]\n";
    print "-S <min_time>        : min time for analysis                    [default min_time = 0]\n";
    print "-u <cutoff>          : plot all logodds, but add stats for those above cutoff [default cutoff = 0]\n";
    print "-w <displaycutoff>   : plot logodds larger than dislplaycutoff                [default display_cutoff = 0]\n";
    print "-y <min_ord>          : min ordinate for plotting scores\n";
    print "-Y <max_ord>          : max ordinate for plotting scores\n";
        exit;
}

my $file   = shift;
my $filesh = shift;

my $seeplots = 0;

my $param_file;
my $param_curve;
if ($opt_p) { $param_file = $opt_p; $param_curve  = "$param_file.plot"; }

my $evalue;
my @evd_cutoff_cod;
my @evd_cutoff_rna;
my $evd_cutoff_curve_cod;
my $evd_cutoff_curve_rna;
if ($opt_e) { $evalue = $opt_e; $evd_cutoff_curve_cod = "evd_cuotff_curve_cod"; $evd_cutoff_curve_rna = "evd_cuotff_curve_rna"; }

my $key;
my $dir;
if     ($file =~ /(.+qfile)\/(\S+)/)  { $dir = $1; $key = $2; }
elsif  ($file =~ /(.+qrna.+)\/(\S+)/) { $dir = $1; $key = $2; }
else                                  { $key = $file; }

my $keysh;
my $dirsh;
if     ($filesh =~ /(.+qfile)\/(\S+)/)  { $dirsh = $1; $keysh = $2; }
elsif  ($filesh =~ /(.+qrna.+)\/(\S+)/) { $dirsh = $1; $keysh = $2; }
else                                    { $keysh = $filesh; }

my $pi = atan2(1,1)*4;

#
#options
#
my $max_n_ali;
if ($opt_a) { $max_n_ali = $opt_a; }
else        { $max_n_ali = 1000000; }

my $type_of_score;
if ($opt_s) { $type_of_score = $opt_s;      }
else        { $type_of_score = "sigmoidal"; }
if ($type_of_score =~ /^simple$/ || $type_of_score =~ /^sigmoidal$/) { ;}
else { print "wrong type of score. options are: 'simple' or 'sigmoidal'"; die; }
		  
my $inc_t;
if ($opt_n) { $inc_t = $opt_n; }
else        { $inc_t = 0.01;   }

my $case;
if ($opt_c) { $case = $opt_c; }
else        { $case = 1;      }

my $cutoff;
if ($opt_u) { $cutoff = $opt_u; }
else        { $cutoff = 0.0;    }

my $display_cutoff;
if (!$param_file) {
    if ($opt_w) { $display_cutoff = $opt_w; }
    else        { $display_cutoff = 0.0;    }
}

my $max_time_plot;
if ($opt_t) { $max_time_plot = $opt_t; }
else        { $max_time_plot = 0.8;     }

my $divide_lodsc;
if ($opt_d) { $divide_lodsc = $opt_d; }
else        { $divide_lodsc = 0.0;      }

my $max_gap_plot;
if ($opt_g) { $max_gap_plot = $opt_g; }
else        { $max_gap_plot = 50;     }
my $min_id_plot;
if ($opt_i) { $min_id_plot = $opt_i; }
else        { $min_id_plot = 50;     }
my $max_id_plot;
if ($opt_j) { $max_id_plot = $opt_j; }
else        { $max_id_plot = 100;     }
my $max_mut_plot;
if ($opt_m) { $max_mut_plot = $opt_m; }
else        { $max_mut_plot = 50;     }

my $min_id;
if ($opt_I) { $min_id = $opt_I; if ($min_id_plot > $min_id) { $min_id_plot = $opt_I; } }
else        { $min_id = 0;      }
my $max_id;
if ($opt_J) { $max_id = $opt_J; if ($max_id_plot < $max_id) { $max_id_plot = $opt_J; } }
else        { $max_id = 100;      }

my $max_time;
if ($opt_T) { $max_time = $opt_T; }
else        { $max_time = 0.8;    }
my $min_time;
if ($opt_S) { $min_time = $opt_S; }
else        { $min_time = 0;      }
my $min_sc_plot;
if ($opt_y) { $min_sc_plot = $opt_y; }
else        { $min_sc_plot = -1;     }
my $max_sc_plot;
if ($opt_Y) { $max_sc_plot = $opt_Y; }
else        { $max_sc_plot = -1;     }

my $max_num_win;
if ($opt_l) { if ($opt_l < 0) { print "non-trivial number of windows, please\n"; die; } $max_num_win = $opt_l; }
else        { $max_num_win = -1;     }


my $min_id_sc = 0;
my $max_id_sc = 100;

my $outfile   = "$file.time";
my $outfilesh = "$filesh.time";

my $outplotcod   = "$file.spreadcod";
my $outplotrna   = "$file.spreadrna";

my $outplotidcod = "$file.id.spreadcod";
my $outplotidrna = "$file.id.spreadrna";

my $outplotshcod   = "$filesh.spreadcod";
my $outplotshrna   = "$filesh.spreadrna";

my $outplotidshcod = "$filesh.id.spreadcod";
my $outplotidshrna = "$filesh.id.spreadrna";

my $codschisto   = $file."_histo_codsc";
my $rnaschisto   = $file."_histo_rnasc";

my $codschistosh = $filesh."_histo_codsc";
my $rnaschistosh = $filesh."_histo_rnasc";

my $tag;
if   ($case==0) { $tag = "GLOBAL";        }
elsif($case==1) { $tag = "LOCAL_DIAG_VITERBI"; }
elsif($case==2) { $tag = "LOCAL_DIAG_FORWARD"; }
elsif($case==3) { $tag = "LOCAL_SEMI_VITERBI"; }
elsif($case==4) { $tag = "LOCAL_SEMI_FORWARD"; }
elsif($case==5) { $tag = "LOCAL_FULL_VITERBI"; }
elsif($case==6) { $tag = "LOCAL_FULL_FORWARD"; }    

#init for EVD histograms
my @evd_rna;
my @evd_cod;

my $Nlsc = 500;
my $klsc = 1/1;
my $shiftl = 250;

my $Nsc = 1500;
my $ksc = 1/1;
my $shift = 1100;

my $Nid = 100;
my $kid = 1/1;

my $Ngap = 100;
my $kgap = 1/2;

my $Nmut = 100;
my $kmut = 1/2;

my $Ngc = 100;
my $kgc = 1/2;

my $Nt = $max_time_plot;
my $kt = 1.0/(2.0*$inc_t);

my $count       = 0; 
my $count_COD   = 0;
my $count_RNA   = 0;
my $count_total = 0; 

my $count_above     = 0; 
my $count_COD_above = 0;
my $count_RNA_above = 0;

my $countsh       = 0; 
my $count_CODsh   = 0;
my $count_RNAsh   = 0;
my $countsh_total = 0; 

my $countsh_above     = 0; 
my $count_CODsh_above = 0;
my $count_RNAsh_above = 0;

my $max_x_cod;
my $max_y_cod;
my $max_x_rna;
my $max_y_rna;
my $max_x_id_cod;
my $max_y_id_cod;
my $max_x_id_rna;
my $max_y_id_rna;

my $is_qrna_12b    = 0;
my $is_sh_qrna_12b = 0;

my $len_ave;
my $len_std;
my $len_ave_sh;
my $len_std_sh;

my $gc_ave;
my $gc_std;
my $gc_ave_sh;
my $gc_std_sh;

my $n_ali_sc;
my $n_ali_sh_sc;

if ($param_file) { cutoff_curve ($param_curve, $param_file, $Nid, $kid); }

if ($evalue) { cal_evd_distribution ($filesh, $Nid, $kid, $Nsc, $ksc, $min_id, $max_id, \@evd_cutoff_cod, $evd_cutoff_curve_cod, \@evd_cutoff_rna, $evd_cutoff_curve_rna); }

$is_qrna_12b = 
    parse_file($outfile,   $outplotcod,   $outplotrna,   $outplotidcod,   $outplotidrna,   $codschisto,  $rnaschisto,    $file,   $key,   
	       $max_num_win,  $min_id, $max_id, 
	       $Nid, $kid, $Ngap, $kgap, $Nmut, $kmut, $Nt, $kt, $Ngc, $kgc, $type_of_score, \$len_ave, \$len_std, \$gc_ave, \$gc_std, \$n_ali_sc,
	       \$count_total, \$count, \$count_above, \$count_COD, \$count_COD_above, \$count_RNA, \$count_RNA_above);

$is_sh_qrna_12b = 
    parse_file($outfilesh, $outplotshcod, $outplotshrna, $outplotidshcod, $outplotidshrna, $codschistosh, $rnaschistosh, $filesh, $keysh, 
	       $max_num_win, $min_id, $max_id, 
	       $Nid, $kid, $Ngap, $kgap, $Nmut, $kmut, $Nt, $kt, $Ngc, $kgc, $type_of_score, \$len_ave_sh, \$len_std_sh, $gc_ave_sh, \$gc_std_sh, \$n_ali_sh_sc,
	       \$countsh_total, \$countsh, \$countsh_above, \$count_CODsh, \$count_CODsh_above, \$count_RNAsh, \$count_RNAsh_above);

my $version;
if ($is_qrna_12b != $is_sh_qrna_12b) { print "You used different qrna version for the shuffled! $is_qrna_12b $is_sh_qrna_12b\n";   die; }
else { $version = ($is_qrna_12b)? "qrna-1.2b" : "qrna-2.0"; }

#if ($is_qrna_12b == 0) {
#    plot_together($outplotcod,   $outplotshcod,   "COD", "$key.COD.with_shuffle",    "QRNA Best-scoring divergence time", 
#		  $max_time, $min_time, 0,   $max_time_plot, $max_x_cod, $max_y_cod, $len_ave, $len_std,
#                 $count_COD, $count_CODsh, $count_COD_above, $count_CODsh_above, 
#		  $count_above, $countsh_above, $count, $countsh, $count_total, $countsh_total);
#    plot_together($outplotrna,   $outplotshrna,   "RNA", "$key.RNA.with_shuffle",    "QRNA Best-scoring divergence time", 
#		  $max_time, $min_time, 0,   $max_time_plot, $max_x_rna, $max_y_rna, $len_ave, $len_std,
#                 $count_RNA, $count_RNAsh, $count_RNA_above, $count_RNAsh_above, $
#		  count_above, $countsh_above, $count, $countsh, $count_total, $countsh_total
#}

plot_together($outplotidcod, $outplotidshcod, "COD", "$key.COD.with_shuffle.id--$type_of_score LOD", "\% ID", $type_of_score,                        
	      $max_id, $min_id, $max_id_plot, $min_id_plot, $min_sc_plot, $max_sc_plot,
	      $max_x_id_cod, $max_y_id_cod, $len_ave, $len_std,
	      $count_COD, $count_CODsh, $count_COD_above, $count_CODsh_above, 
	      $count_above, $countsh_above, $count, $countsh, $count_total, $countsh_total);
plot_together($outplotidrna, $outplotidshrna, "RNA", "$key.RNA.with_shuffle.id--$type_of_score LOD", "\% ID", $type_of_score,                           
	      $max_id, $min_id, $max_id_plot, $min_id_plot, $min_sc_plot, $max_sc_plot,
	      $max_x_id_rna, $max_y_id_rna, $len_ave, $len_std,
	      $count_RNA, $count_RNAsh, $count_RNA_above, $count_RNAsh_above, 
	      $count_above, $countsh_above, $count, $countsh, $count_total, $countsh_total);

my $per_tp  = int(10000*$count_RNA_above/$count_total)/100;
my $per_Rfp = int(10000*$count_RNAsh_above/$count_total)/100;
my $per_Cfp = int(10000*$count_COD_above/$count_total)/100;
my $family;

if (0) {
if ($key =~/Rfam.(\S+).fa/) { $family = $1;   }
else                        { $family = $key; }

my $table_file = $file."_table";
open (TABLE,">$table_file") || die;

print TABLE "RNA family\t\tave_len\tave_GC\t\# alignments     \% TP            \% RNA FP        \% COD FP\n";
print TABLE "$family\t$len_ave\t$gc_ave\t$count_total\t\t $count_RNA_above ($per_tp\%)\t $count_RNAsh_above ($per_Rfp\%)\t $count_COD_above ($per_Cfp\%)\n";

gnuplot_histo_together($codschisto, $codschistosh, "PERCENTAGE ID [$min_id_sc,$max_id_sc] [ \# windows = $n_ali_sc ]",    "COD_LODSCORES", "Fraction of windows", $key);
gnuplot_histo_together($rnaschisto, $rnaschistosh, "PERCENTAGE ID [$min_id_sc,$max_id_sc] [ \# windows = $n_ali_sh_sc ]", "RNA_LODSCORES", "Fraction of windows", $key);
}

if (0) {
plot_select($outplotidrna, $outplotidshrna, "RNA", "$key.RNA.with_shuffle.id--$type_of_score LOD", "\% ID", $type_of_score,                           
	      $max_id, $min_id, $max_id_plot, $min_id_plot, $min_sc_plot, $max_sc_plot,
	      $max_x_id_rna, $max_y_id_rna, $len_ave, $len_std,
	      $count_RNA, $count_RNAsh, $count_RNA_above, $count_RNAsh_above, 
	      $count_above, $countsh_above, $count, $countsh, $count_total, $countsh_total);
}


#
# subroutines
#


sub accumulate_averages {

    my ($N, $k, $valx, $valy, $max_ref, $ave_ref, $std_ref, $num_ref) = @_;

    my $dim = $N * $k;
    
    my $func; 

    for (my $i=0; $i<=$dim; $i++) { 
	if ( $i/$k <= $valx && $valx < ($i+1)/$k) { 

	    $num_ref->[$i] ++;
	    
	    $func = $valy; 
	    
	    $ave_ref->[$i] += $func; 
	    $std_ref->[$i] += $func * $func;	

	    if ($func > $max_ref->[$i]) { $max_ref->[$i] = $func; }
	}
    }
}

sub angle {
    my $x = $_[0];
    my $y = $_[1];

    my $pos_angle = atan2(abs($y),abs($x));

    my $ang;
    
    if    ($y >= 0 && $x >= 0) { $ang =  $pos_angle;         }
    elsif ($y >= 0 && $x <  0) { $ang =  $pi/2 + $pos_angle; }
    elsif ($y <  0 && $x >= 0) { $ang = -$pos_angle;         }
    elsif ($y <  0 && $x <  0) { $ang = -$pi + $pos_angle;   }
   
    return $ang;
}

sub cal_evd_distribution {
    my ($file, $Nid, $kid, $Nsc, $ksc, $min_id, $max_id, $evd_cutoff_cod_ref, $evd_cuotff_curve_cod, $evd_cutoff_rna_ref, $evd_cuotff_curve_rna) = @_;

    init_evd_array ($Nid, $kid, $Nsc, $ksc, \@evd_rna);
    init_evd_array ($Nid, $kid, $Nsc, $ksc, \@evd_cod);

    my $othsc;
    my $codsc;
    my $rnasc;

    my $codlod;
    my $rnalod;

    my $othlodsigm;
    my $codlodsigm;
    my $rnalodsigm;

    my $id;

    open (FILE,"$file") || die;
    while (<FILE>) {
	
	if (/^length alignment:\s+\d+\s+\(id=(\d+\.\d+)\)/) 
	{ 
	    
	    $id  = $1;
	    
	    
	}  elsif (/^\s+OTH =\s+(\S+)\s+COD =\s+(\S+)\s+RNA =\s+(\S+)\s+$/) 
	{ 
	    $othsc = $1; 
	    $codsc = $2;
	    $rnasc = $3;	
	    
	    if ($id >= $min_id && $id <= $max_id) {
		
		$codlod = $codsc - $othsc;
		$rnalod = $rnasc - $othsc;
		
		$othlodsigm = - log(exp(log(2.0)*($codsc-$othsc)) + exp(log(2.0)*($rnasc-$othsc)))/log(2.0);
		$codlodsigm = - log(exp(log(2.0)*($othsc-$codsc)) + exp(log(2.0)*($rnasc-$codsc)))/log(2.0);
		$rnalodsigm = - log(exp(log(2.0)*($othsc-$rnasc)) + exp(log(2.0)*($codsc-$rnasc)))/log(2.0);

		if ($type_of_score =~  /^simple$/) {
		    
		    fill_evd_array ($rnalod, $Nsc, $ksc, $shift, $evd_rna[$id]); 
		    fill_evd_array ($codlod, $Nsc, $ksc, $shift, $evd_cod[$id]); 
		}
		
		else {
		    
		    fill_evd_array ($rnalodsigm, $Nsc, $ksc, $shift, $evd_rna[$id]); 
		    fill_evd_array ($codlodsigm, $Nsc, $ksc, $shift, $evd_cod[$id]); 
		}
	    }
	}
    }
    close (FILE);
    close (OUT);
    
    write_evd_array($Nid, $kid, $Nsc, $ksc, \@evd_rna);
    write_evd_array($Nid, $kid, $Nsc, $ksc, \@evd_cod);
    
    evd_cutoff($Nid, $kid, $Nsc, $ksc, \@evd_cod, $evalue, $evd_cutoff_cod_ref, $evd_cuotff_curve_cod);
    evd_cutoff($Nid, $kid, $Nsc, $ksc, \@evd_rna, $evalue, $evd_cutoff_rna_ref, $evd_cuotff_curve_rna);
}

sub calculate_averages {
    
    my ($N, $k, $ave_ref, $std_ref, $number_ref) = @_;
    
    my $dim = $N * $k;
    
    my $max_val = 0;
    my $min_val = $dim;
    my $ext_val;

   for (my $i=0; $i<=$dim; $i++) {
	if ($number_ref->[$i] > 1) 
	{ 
	    $ave_ref->[$i] /= $number_ref->[$i];
	    $std_ref->[$i] -= $ave_ref->[$i]*$ave_ref->[$i]*$number_ref->[$i]; 
	    $std_ref->[$i] /= ($number_ref->[$i]-1);
	    if ($std_ref->[$i] > -0.0001 && $std_ref->[$i] < 0.0) { $std_ref->[$i] = 0.0 }
	    $std_ref->[$i]  = sqrt($std_ref->[$i]);

	    # print " $i  $number_ref->[$i] $ave_ref->[$i] $std_ref->[$i]\n";

	    $max_val = $i;
	}
	elsif ($number_ref->[$i] == 1)                 
	{ 
	    $ave_ref->[$i] /= $number_ref->[$i];
	    $std_ref->[$i] = 0.0;    

	    $max_val = $i;
 	}
	else 
	{
	    $ave_ref->[$i] = 0.0;                                                                                      
	    $std_ref->[$i] = 0.0;    

	    $min_val = $i+1;
	}
    }
    
    if ($max_val >= $min_val) { $ext_val = $min_val/$k; }
    else                      { $ext_val = $max_val/$k; }

    return $ext_val;
}


sub cutoff_curve {
    my ($param_curve, $param_file, $N, $k) = @_;

    my $m1;
    my $m1_err;
    my $m2;
    my $m2_err;

    my $a1_exp;
    my $a1_err;
    my $a2_exp;
    my $a2_err;

    my $keye1;    
    my $keye2;    
    
    # do exp fit
    #
    #
    my $abs_id  = 100;
    my $max_id  = 99;
    my $half_id = 55;   # change of fitting curve point
    my $min_id  = 0;

    my $asyntote_id  = 25;   #change into an asyntote

    my $abs_lod  =   8.0;
    my $max_lod  =  15.0;

    my $id;
    my $lod;

    my $lod_half_id = fit_half_exp ("$param_file", \$a1_exp, \$a1_err, \$m1, \$m1_err, $max_id,  $half_id, $max_lod);
    my $lod_min_id  = fit_half_exp ("$param_file", \$a2_exp, \$a2_err, \$m2, \$m2_err, $half_id, $min_id,  $lod_half_id);

    my $lod_asyntote_id = $lod_half_id - $a2_exp * ($half_id - $asyntote_id) ** $m2;

    $keye1 = "fit\[$max_lod - $a1_exp * ($max_id -x) ^ $m1\]"; 
    $keye2 = "fit\[$lod_half_id - $a2_exp * ($half_id-x) ^ $m2\]"; 
    
    open (PARAM,">$param_curve") || die;
    print PARAM "#file: $param_curve\n";
    print PARAM "#fit1: $keye1\n";
    print PARAM "#fit2: $keye2\n";
    
    my $fun;
    my $dim = $N*$k;
    my $x;
    for (my $i = 0; $i <= $dim; $i++) {
	$x = $i/$k;
	 
	if    ($x >= $max_id)                        { $fun = $abs_lod;                                        print PARAM "$x $fun\n"; }
	elsif ($x <  $max_id  && $x >= $half_id)     { $fun = $max_lod     - $a1_exp * ($max_id  - $x) ** $m1; print PARAM "$x $fun\n"; }
	elsif ($x <  $half_id && $x >= $asyntote_id) { $fun = $lod_half_id - $a2_exp * ($half_id - $x) ** $m2; print PARAM "$x $fun\n"; }
	else                                         { $fun = $lod_asyntote_id;                                print PARAM "$x $fun\n"; }
	
    }
    close(PARAM);


}

sub cutoff_for_id {

    my ($param_curve, $id, $Nid, $kid) = @_;
    
    my $cutoff;
    my $x;
    my $y;

    open (PARAM, "$param_curve") || die;
    while(<PARAM>) {
	if (/^\#/) {
	    next;
	}
	if (/^(\S+)\s+(\S+)/) {
	    
	    $x = $1;
	    $y = $2;
	    
	    if ($id/$kid <= $x && $x < ($id+1)/$kid) { $cutoff = $y; last; }

	}
    }
    close(PARAM);
    

    return $cutoff;

}


sub distribute_simple_scores {    

    my ($codlod, $rnalod,
	$display_cutoff_cod, $display_cutoff_rna, $cutoff,
	$Nid,  $kid,  $id,
	$Ngap, $kgap, $gap,
	$Nmut, $kmut, $mut,
	$Nt,   $kt,   $time,
	$Ngc,  $kgc,  $gc,
	$his_id_above_ref, $his_time_above_ref, 
	$his_id_COD_ref , $his_gap_COD_ref, $his_mut_COD_ref , $his_gc_COD_ref,
	$his_id_RNA_ref , $his_gap_RNA_ref, $his_mut_RNA_ref , $his_gc_RNA_ref,
	$spread_cod_max_ref,     $spread_cod_ave_ref,     $spread_cod_std_ref,     $num_cod_spread_ref,
	$spread_id_cod_max_ref,  $spread_id_cod_ave_ref,  $spread_id_cod_std_ref,  $num_id_cod_spread_ref,
	$spread_rna_max_ref,     $spread_rna_ave_ref,     $spread_rna_std_ref,     $num_rna_spread_ref,
	$spread_id_rna_max_ref,  $spread_id_rna_ave_ref,  $spread_id_rna_std_ref,  $num_id_rna_spread_ref,
	$tspread_cod_max_ref,    $tspread_cod_ave_ref,    $tspread_cod_std_ref,    $tnum_cod_spread_ref,
	$tspread_id_cod_max_ref, $tspread_id_cod_ave_ref, $tspread_id_cod_std_ref, $tnum_id_cod_spread_ref,
	$tspread_rna_max_ref,    $tspread_rna_ave_ref,    $tspread_rna_std_ref,    $tnum_rna_spread_ref,
	$tspread_id_rna_max_ref, $tspread_id_rna_ave_ref, $tspread_id_rna_std_ref, $tnum_id_rna_spread_ref,
	$count_ref, $count_above_ref, $count_COD_ref, $count_COD_above_ref, $count_RNA_ref, $count_RNA_above_ref) = @_;

    my $winner;
    my $winner_cutoff;

    my $cod_distance;
    my $rna_distance;

    #distance is the min distance to any of the other phase
    $cod_distance = ($codlod - $rnalod) / sqrt(2.0);
    if ($codlod < $cod_distance) { $cod_distance = $codlod; }	    

    $rna_distance = ($rnalod - $codlod) / sqrt(2.0);
    if ($rnalod < $rna_distance) { $rna_distance = $rnalod; }
    
    accumulate_averages ($Nt,  $kt,  $time, $cod_distance, $tspread_cod_max_ref,    $tspread_cod_ave_ref,    $tspread_cod_std_ref,     $tnum_cod_spread_ref);
    accumulate_averages ($Nid, $kid, $id,   $cod_distance, $tspread_id_cod_max_ref, $tspread_id_cod_ave_ref, $tspread_id_cod_std_ref,  $tnum_id_cod_spread_ref);
    accumulate_averages ($Nt,  $kt,  $time, $rna_distance, $tspread_rna_max_ref,    $tspread_rna_ave_ref,    $tspread_rna_std_ref,     $tnum_rna_spread_ref);
    accumulate_averages ($Nid, $kid, $id,   $rna_distance, $tspread_id_rna_max_ref, $tspread_id_rna_ave_ref, $tspread_id_rna_std_ref,  $tnum_id_rna_spread_ref);
    
    if (is_above_cutoff($cutoff, $cutoff, \$winner_cutoff, $codlod, $rnalod)) {	
	
	$$count_above_ref ++;
	
	if ($winner_cutoff =~ /^COD$/) { 
	    $$count_COD_above_ref ++; 

	    accumulate_averages ($Nt,  $kt,  $time, $cod_distance, $spread_cod_max_ref,    $spread_cod_ave_ref,    $spread_cod_std_ref,     $num_cod_spread_ref);
	    accumulate_averages ($Nid, $kid, $id,   $cod_distance, $spread_id_cod_max_ref, $spread_id_cod_ave_ref, $spread_id_cod_std_ref,  $num_id_cod_spread_ref);
	 
	}
	
	if ($winner_cutoff =~ /^RNA$/) { 
	    $$count_RNA_above_ref ++; 

	    accumulate_averages ($Nt,  $kt,  $time, $rna_distance, $spread_rna_max_ref,    $spread_rna_ave_ref,    $spread_rna_std_ref,     $num_rna_spread_ref);
	    accumulate_averages ($Nid, $kid, $id,   $rna_distance, $spread_id_rna_max_ref, $spread_id_rna_ave_ref, $spread_id_rna_std_ref,  $num_id_rna_spread_ref);
	    
	}

    }
    
    if (is_above_cutoff($display_cutoff_cod, $display_cutoff_rna, \$winner, $codlod, $rnalod)) {
	
	$$count_ref ++;
	
	if ($winner =~ /^COD$/) {		
	    
	    fill_histo_array ($id,  $Nid,  $kid,  $his_id_COD_ref); 
	    fill_histo_array ($gap, $Ngap, $kgap, $his_gap_COD_ref); 
	    fill_histo_array ($mut, $Nmut, $kmut, $his_mut_COD_ref); 
	    fill_histo_array ($gc,  $Ngc,  $kgc,  $his_gc_COD_ref); 
	    
	    $$count_COD_ref ++;
	    	    
	}
	if ($winner =~ /^RNA$/) {

	    fill_histo_array ($id,  $Nid,  $kid,  $his_id_RNA_ref); 
	    fill_histo_array ($gap, $Ngap, $kgap, $his_gap_RNA_ref); 
	    fill_histo_array ($mut, $Nmut, $kmut, $his_mut_RNA_ref); 
	    fill_histo_array ($gc,  $Ngc,  $kgc,  $his_gc_RNA_ref); 
	    
	    $$count_RNA_ref ++;
	    
	}
    }
    
}


sub distribute_sigmoidal_scores {

    my ($othlodsigm, $codlodsigm, $rnalodsigm,
	$display_cutoff_cod, $display_cutoff_rna, $cutoff,
	$Nid,  $kid,  $id,
	$Ngap, $kgap, $gap,
	$Nmut, $kmut, $mut,
	$Nt,   $kt,   $time,
	$Ngc,  $kgc,  $gc,
	$his_id_above_ref, $his_time_above_ref, 
	$his_id_COD_ref , $his_gap_COD_ref, $his_mut_COD_ref , $his_gc_COD_ref,
	$his_id_RNA_ref , $his_gap_RNA_ref, $his_mut_RNA_ref , $his_gc_RNA_ref,
	$spread_cod_max_ref,     $spread_cod_ave_ref,     $spread_cod_std_ref,     $num_cod_spread_ref,
	$spread_id_cod_max_ref,  $spread_id_cod_ave_ref,  $spread_id_cod_std_ref,  $num_id_cod_spread_ref,
	$spread_rna_max_ref,     $spread_rna_ave_ref,     $spread_rna_std_ref,     $num_rna_spread_ref,
	$spread_id_rna_max_ref,  $spread_id_rna_ave_ref,  $spread_id_rna_std_ref,  $num_id_rna_spread_ref,
	$tspread_cod_max_ref,    $tspread_cod_ave_ref,    $tspread_cod_std_ref,    $tnum_cod_spread_ref,
	$tspread_id_cod_max_ref, $tspread_id_cod_ave_ref, $tspread_id_cod_std_ref, $tnum_id_cod_spread_ref,
	$tspread_rna_max_ref,    $tspread_rna_ave_ref,    $tspread_rna_std_ref,    $tnum_rna_spread_ref,
	$tspread_id_rna_max_ref, $tspread_id_rna_ave_ref, $tspread_id_rna_std_ref, $tnum_id_rna_spread_ref,
	$count_ref, $count_above_ref, $count_COD_ref, $count_COD_above_ref, $count_RNA_ref, $count_RNA_above_ref) = @_;

    my $winner;
    my $winner_cutoff;

    accumulate_averages ($Nt,  $kt,  $time, $codlodsigm, $tspread_cod_max_ref,    $tspread_cod_ave_ref,    $tspread_cod_std_ref,     $tnum_cod_spread_ref);
    accumulate_averages ($Nid, $kid, $id,   $codlodsigm, $tspread_id_cod_max_ref, $tspread_id_cod_ave_ref, $tspread_id_cod_std_ref,  $tnum_id_cod_spread_ref);
    accumulate_averages ($Nt,  $kt,  $time, $rnalodsigm, $tspread_rna_max_ref,    $tspread_rna_ave_ref,    $tspread_rna_std_ref,     $tnum_rna_spread_ref);
    accumulate_averages ($Nid, $kid, $id,   $rnalodsigm, $tspread_id_rna_max_ref, $tspread_id_rna_ave_ref, $tspread_id_rna_std_ref,  $tnum_id_rna_spread_ref);
    
    if (is_above_cutoff_sigmoidal($cutoff, $cutoff, \$winner_cutoff, $codlodsigm, $rnalodsigm)) {	
	
	$$count_above_ref ++;
	
	fill_histo_array ($id,   $Nid, $kid, $his_id_above_ref); 
	fill_histo_array ($time, $Nt,  $kt,  $his_time_above_ref); 
	
	if ($winner_cutoff =~ /^COD$/) { 

	    $$count_COD_above_ref ++; 

	    accumulate_averages ($Nt,  $kt,  $time, $codlodsigm, $spread_cod_max_ref,    $spread_cod_ave_ref,    $spread_cod_std_ref,     $num_cod_spread_ref);
	    accumulate_averages ($Nid, $kid, $id,   $codlodsigm, $spread_id_cod_max_ref, $spread_id_cod_ave_ref, $spread_id_cod_std_ref,  $num_id_cod_spread_ref);	    
	}

	if ($winner_cutoff =~ /^RNA$/) { 
	    $$count_RNA_above_ref ++; 

	    accumulate_averages ($Nt,  $kt,  $time, $rnalodsigm, $spread_rna_max_ref,    $spread_rna_ave_ref,    $spread_rna_std_ref,     $num_rna_spread_ref);
	    accumulate_averages ($Nid, $kid, $id,   $rnalodsigm, $spread_id_rna_max_ref, $spread_id_rna_ave_ref, $spread_id_rna_std_ref,  $num_id_rna_spread_ref);
	    
	}

    }
    
    if (is_above_cutoff_sigmoidal($display_cutoff_cod, $display_cutoff_rna, \$winner, $codlodsigm, $rnalodsigm)) {
	
	$$count_ref ++;
	
	if ($winner =~ /^COD$/) {		
	    

	    fill_histo_array ($id,  $Nid,  $kid,  $his_id_COD_ref); 
	    fill_histo_array ($gap, $Ngap, $kgap, $his_gap_COD_ref); 
	    fill_histo_array ($mut, $Nmut, $kmut, $his_mut_COD_ref); 
	    fill_histo_array ($gc,  $Ngc,  $kgc,  $his_gc_COD_ref); 
	    
	    $$count_COD_ref ++;
	    
	}
	if ($winner =~ /^RNA$/) {

	    fill_histo_array ($id,  $Nid,  $kid,  $his_id_RNA_ref); 
	    fill_histo_array ($gap, $Ngap, $kgap, $his_gap_RNA_ref); 
	    fill_histo_array ($mut, $Nmut, $kmut, $his_mut_RNA_ref); 
	    fill_histo_array ($gc,  $Ngc,  $kgc,  $his_gc_RNA_ref); 
	    
	    $$count_RNA_ref ++;
	    
	}
    }
    
}
 
sub evd_cutoff {

    my ($Nid, $kid, $Nsc, $ksc, $evd_ref, $evalue, $evd_cutoff_ref, $evd_cuotff_curve) = @_;

    my $dim_id = $Nid * $kid;
    my $dim_sc = $Nsc * $ksc;
    
    my $p = 1.0 - exp(-$evalue);

    for (my $i = 0; $i <= $dim_id; $i++) {
	for (my $sc = 0; $sc <= $dim_sc; $sc++) { 
	    if ($evd_ref->[$i][$sc] < 1.0 && $evd_ref->[$i][$sc] > $p)  { $evd_cutoff_ref->[$i] = $sc-$shift; }
	}
    }
    
    open (FILE,">$evd_cuotff_curve") || die;
    for (my $i = 0; $i <= $dim_id; $i++) {
	print FILE "$i $evd_cutoff_ref->[$i]\n";
    }
    close(FILE);
    
    #system("more $evd_cuotff_curve\n");
}

sub exp_fit {
    my ($outplot, $title, $xtitle, $N, $k, $x0, $x1, $fit_max, $max_x, $max_y, $decrease, $divide_lodsc) = @_;

    my $m;
    my $m_err;
    my $a;
    my $a_err;
    my $fit;

    my $outplot_ex  = "$outplot.fit";
    my $outplot_fit = "$outplot_ex.param";

    # do exp fit
    #
    #
    if ($fit_max == 1) { $fit = "7"; }
    else               { $fit = "7"; }


    my $divide_x = -1;

    my $x;
    my $max;
    my $ave;

   open (FILE,"$outplot") || die;
    while(<FILE>) {

	if (/^(\S+)\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+(\S+)\s+(\S+)/) {
	    $x = $1;
	    $max = $2;
	    $ave = $3;
	    
	    if ($decrease == 0 && $ave > $divide_lodsc) { $divide_x = $x; }
	    if ($decrease == 1 && $x < $max_x && $ave < $divide_lodsc) { $divide_x = $x; }
	}
    }
    close (FILE);

    open (FO,">foo") || die;
    open (FILE,"$outplot") || die;
    while(<FILE>) {

	if (/^(\S+)\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+\S+\s+(\S+)\s+(\S+)/) {
	    $x = $1;
	    $max = $2;
	    $ave = $3;
	    print " paso $max_x $max_y $divide_x $divide_lodsc $decrease $x $max $ave\n";
    
	    if ($decrease == 0) {
		if ($x > $max_x && $x <= $divide_x && $max_y > $ave) {
		    printf(FO "%.4f %.4f\n", log($x-$max_x), log($max_y-$ave));
		}  
	    }
	    elsif ($decrease == 1) {
		if ($x < $max_x && $x >= $divide_x && $max_y > $ave) {
		    printf(FO "%.4f %.4f\n", log($max_x-$x), log($max_y-$ave));
		}  
	    }
	    else { print "die in exp_fit\n"; die; }
	}  
    }
    close (FILE);
    close(FO);


    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    print GP "fe(x) = m*x + a\n"; 
    print GP "fit fe(x) 'foo' using 1:2  via m,a \n";
    close (GP);

    extract_exp_fit_info ("fit.log", "foo", \$m, \$a);

    $m =~ /(\S+)(\(\S+\%\))/;  $m = $1; $m_err = $2;
    $a =~ /(\S+)(\(\S+\%\))/;  $a = $1; $a_err = $2;

    my $a_exp = exp ($a);

    my $keye;    

    if    ($decrease == 0) { $keye = "fit\[$max_y - $a_exp$a_err * (x-$max_x) ^ $m$m_err\]"; }
    elsif ($decrease == 1) { $keye = "fit\[$max_y - $a_exp$a_err * ($max_x-x) ^ $m$m_err\]"; }

    open (PARAM,">$outplot_fit") || die;
    print PARAM "#$outplot_fit\n";
    print PARAM "#$keye\n";

    my $fun;
    my $dim = $N*$k;
    for (my $i = 0; $i <= $dim; $i++) {
	$x = $i/$k;

	if ($decrease == 0) {
	    if ($x <= $max_x)                        { $fun = $max_y;                                }
	    if ($x >= $max_x     && $x <= $divide_x) { $fun = $max_y - exp($a) * ($x-$max_x) ** $ m; }
	    if ($x >=  $divide_x && $x <= $x1)       { $fun = $divide_lodsc;                         }
	}
	if ($decrease == 1) {
	    if ($x >= $max_x)                       { $fun = $max_y;                                }
	    if ($x <= $max_x    && $x >= $divide_x) { $fun = $max_y - exp($a) * ($max_x-$x) ** $ m; }
	    if ($x <= $divide_x && $x >= $x1)       { $fun = $divide_lodsc;                         }
	}
	
	print PARAM "$x $fun\n";
    }
    close(PARAM);
    
    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    print GP "set terminal postscript  default color\n";
    print GP "set output '$outplot_ex.ps'\n";
    print GP "set title '$title'\n"; 
    print GP "set xlabel '$xtitle'\n";
    print GP "set ylabel 'LODSCORE'\n";

    if    ($decrease == 0) { print GP "fe(x) = $max_y - exp($a) * (x-$max_x) ** $m\n"; }
    elsif ($decrease == 1) { print GP "fe(x) = $max_y - exp($a) * ($max_x-x) ** $m\n"; }

    print GP "plot [$x0:$x1] '$outplot_fit' using 1:2 title '$keye' with lines 1, '$outplot' using 1:11 title 'max' 2, '$outplot' using 1:12:13 title 'ave' with errorbars 3\n";
    close(GP);
    
    #system ("gv -landscape -magstep -2 $outplot_ex.ps&\n"); 
    system ("rm 'fit.log'\n"); 
    system("rm foo\n");


}

sub extract_exp_fit_info {

    my ($fitlog, $plotfile, $m_ref, $a_ref) = @_;

    my $read = 0;

    open (FIT,"$fitlog") || die;
    while (<FIT>) {
	
	if (/^FIT:.+$plotfile/) { $read = 1; }
	elsif (/^FIT:/)         { $read = 0; }

	if    (/^m\s+=\s+(\S+)\s+\+\/\-\s+\S+\s+(\(\S+\%\))/)  { if ($read == 1) { $$m_ref  = $1.$2; } }
	elsif (/^a\s+=\s+(\S+)\s+\+\/\-\s+\S+\s+(\(\S+\%\))/)  { if ($read == 1) { $$a_ref  = $1.$2; } }
    }
    close (FIT);
 
}


sub  fit_half_exp {

    my ($param_file, $a_exp_ref, $a_err_ref, $m_ref, $m_err_ref, $max_x, $min_x, $max_y) = @_;
    
    my $m;
    my $m_err;
    my $a;
    my $a_err;

    my $x;
    my $y;
    
    my $y_min_x;

    open (FO,">foo") || die;
    open (FILE,"$param_file") || die;
    while(<FILE>) {
	
	if (/^(\S+)\s+(\S+)/) {
	    $x = $1;
	    $y = $2;
	    
	    if ($y <= $max_y && $x < $max_x && $x >= $min_x) {
		printf(FO "%.4f %.4f\n", log($max_x-$x), log($max_y-$y));
	    }
	    
	}
    }
    close (FILE);
    close(FO);
    
    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    print GP "fe(x) = m*x + a\n"; 
    print GP "fit fe(x) 'foo' using 1:2  via m,a \n";
    close (GP);
    
    extract_exp_fit_info ("fit.log", "foo", \$m, \$a);
    
    $m =~ /(\S+)(\(\S+\%\))/;  $m = $1; $m_err = $2;
    $a =~ /(\S+)(\(\S+\%\))/;  $a = $1; $a_err = $2;
    
    my $a_exp = exp ($a);
    
    $a_exp *= 1000;
    $a_exp = int $a_exp;
    $a_exp /= 1000;

    $m *= 1000;
    $m = int $m;
    $m /= 1000;

    $$a_exp_ref = $a_exp;
    $$a_err_ref = $a_err;

    $$m_ref = $m;
    $$m_err_ref = $m_err;

    system ("rm 'fit.log'\n"); 
    system("rm foo\n");

    $y_min_x = $max_y - $a_exp*($max_x-$min_x)**$m;
    $y_min_x *= 1000;
    $y_min_x = int $y_min_x;
    $y_min_x /= 1000;
     
   return $y_min_x
}

sub fit_to_cutoff {
    my ($outplot, $param_curve, $title, $xtitle, $N, $k, $x0, $x1) = @_;

    my $m;
    my $m_err;
    my $a;
    my $a_err;
    my $keye;
    my $keyl;

    my $outplot_ex  = "$outplot.fit";

    open (PARAM,"$param_curve") || die;
     while(<PARAM>) {
	if    (/^\#(fit1.+)/) { $keye = $1; }
	elsif (/^\#(fit2.+)/) { $keyl = $1; }
    }
    close(PARAM);

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    print GP "set terminal postscript  default color\n";
    print GP "set output '$outplot_ex.ps'\n";
    print GP "set title '$title'\n"; 
    print GP "set xlabel '$xtitle'\n";
    print GP "set ylabel 'LODSCORE'\n";

    print GP "plot [$x0:$x1] '$param_curve' using 1:2 title '$keye-$keyl' with lines 1, '$outplot' using 1:11 title 'max' 2, '$outplot' using 1:12:13 title 'ave' with errorbars 3\n";
    close(GP);
    
    #system ("gv -landscape -magstep -2 $outplot_ex.ps&\n"); 


}



sub fill_histo_array {
    my ($len, $N, $k, $his_ref) = @_;
    
    my $dim = $N * $k;
    
    if ($len >=  $N) { $his_ref->[$dim] += 1; return; }
    
    for (my $i=0; $i<$dim; $i++) { 

	if ( $i/$k <= $len && $len < ($i+1)/$k) { 
	    #print "$len ", $i/$k, " ", ($i+1)/$k, " \n"; 
	    $his_ref->[$i] += 1; last; 
	} 
    }
    
}

sub fill_evd_array {
    my ($score, $N, $k, $shift, $evd_ref) = @_;
    
    my $dim = $N * $k;
    
    if ($score >=  $N-$shift) { $evd_ref->[$dim] += 1; return; }
    
    for (my $i=0; $i<$dim; $i++) { if ( $i/$k-$shift <= $score && $score < ($i+1)/$k-$shift) { $evd_ref->[$i] += 1; } }
    
}


sub gnuplot_histo {

    my ($filehisto, $title, $xlabel, $ylabel, $key, $min_x, $max_x) = @_;
      
    my $outplot = "$filehisto.ps";
    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    
    print GP "set terminal postscript  default color solid 14\n";
    print GP "set linestyle 1 lt 1 lw 4\n";
    print GP "set linestyle 2 lt 2 lw 4\n";
    print GP "set linestyle 3  lt 3 lw 4\n";
    print GP "set linestyle 4 lt 4 lw 4\n";
    print GP "set linestyle 5 lt 5 lw 4\n";
    print GP "set linestyle 6 lt 6 lw 4\n";
    print GP "set linestyle 7 lt 7 lw 4\n";
    print GP "set linestyle 8 lt 8 lw 4\n";
    print GP "set linestyle 9 lt 9 lw 4\n";
    print GP "set linestyle 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set linestyle 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set linestyle 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set linestyle 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set linestyle 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set linestyle 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set linestyle 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    #print GP "set nokey\n";
    print GP "set title '$title'\n"; 
    print GP "set ylabel '$ylabel'\n";
    print GP "set xlabel '$xlabel'\n";

    #print GP "plot [$min_x:$max_x] '$filehisto' using 1:2 title '$key' with boxes ls 3\n";
    #print GP "plot [$min_x:$max_x] '$filehisto' using 1:3 title '$key' with lines ls 3\n";
    print GP "plot [$min_x:$max_x] '$filehisto' using 1:4 title '$key' with boxes ls 3\n";
    #print GP "plot [$min_x:$max_x] '$filehisto' using 1:5 title '$key' with lines ls 3\n";
    close (GP);

    if ($seeplots == 1) { system ("gv -landscape -magstep -2 $outplot&\n"); }

}

sub gnuplot_histo_distr {

    my ($filehisto, $title, $xlabel, $ylabel, $key, $min_x, $max_x) = @_;
      
    my $outplot = "$filehisto.ps";
    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    
    print GP "set terminal postscript  default color solid 14\n";
    print GP "set linestyle 1 lt 1 lw 4\n";
    print GP "set linestyle 2 lt 2 lw 4\n";
    print GP "set linestyle 3  lt 3 lw 4\n";
    print GP "set linestyle 4 lt 4 lw 4\n";
    print GP "set linestyle 5 lt 5 lw 4\n";
    print GP "set linestyle 6 lt 6 lw 4\n";
    print GP "set linestyle 7 lt 7 lw 4\n";
    print GP "set linestyle 8 lt 8 lw 4\n";
    print GP "set linestyle 9 lt 9 lw 4\n";
    print GP "set linestyle 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set linestyle 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set linestyle 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set linestyle 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set linestyle 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set linestyle 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set linestyle 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    #print GP "set nokey\n";
    print GP "set title '$title'\n"; 
    print GP "set ylabel '$ylabel'\n";
    print GP "set xlabel '$xlabel'\n";

    print GP "plot [$min_x:$max_x] '$filehisto' using 1:4 title 'random alignments' with boxes ls 3, '$filehisto' using 1:6 title 'Gumbel density distribution' with lines ls 1\n";
    print GP "plot [$min_x:$max_x]  '$filehisto' using 1:5 title '$key' with lines ls 3, '$filehisto' using 1:7 title '$key' with lines ls 1\n";
    close (GP);

    if ($seeplots == 1) { system ("gv -landscape -magstep -2 $outplot&\n"); }

}

sub gnuplot_histo_together {

    my ($filehisto, $filehistosh, $title, $xlabel, $ylabel, $key) = @_;
      
    my $outplot = $filehisto."_with_sh.ps";

    my $error_area = 0;

    my @his;
    my @his_sh;

    my $dim = $Nsc * $ksc;

    init_histo_array ($Nsc, $ksc, \@his);
    init_histo_array ($Nsc, $ksc, \@his_sh);

    my $i;

    open (FILE,"$filehisto") || die;
     while(<FILE>) {
	if    (/^\#/) { next; }
	elsif (/^\s*(\S+)\s+\S+\s+\S+\s+(\S+)/) { $i = $1; $his[$i] = $2; }
    }
    close(FILE);

    open (FILE,"$filehistosh") || die;
     while(<FILE>) {
	if    (/^\#/) { next; }
	elsif (/^\s*(\S+)\s+\S+\s+\S+\s+(\S+)/) { $i = $1; $his_sh[$i] = $2; }
    }
    close(FILE);

    for (my $i = 0; $i <= $dim; $i++) { 
	if ($his[$i] < $his_sh[$i]) { $error_area += $his[$i]; } 
	else                        { $error_area += $his_sh[$i]; } 
    }


    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    
    print GP "set terminal postscript  default color solid 14\n";
    print GP "set linestyle 1 lt 1 lw 4\n";
    print GP "set linestyle 2 lt 2 lw 4\n";
    print GP "set linestyle 3  lt 3 lw 4\n";
    print GP "set linestyle 4 lt 4 lw 4\n";
    print GP "set linestyle 5 lt 5 lw 4\n";
    print GP "set linestyle 6 lt 6 lw 4\n";
    print GP "set linestyle 7 lt 7 lw 4\n";
    print GP "set linestyle 8 lt 8 lw 4\n";
    print GP "set linestyle 9 lt 9 lw 4\n";
    print GP "set linestyle 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set linestyle 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set linestyle 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set linestyle 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set linestyle 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set linestyle 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set linestyle 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    #print GP "set nokey\n";
    print GP "set title '$title -- error area  = $error_area'\n"; 
    print GP "set ylabel '$ylabel'\n";
    print GP "set xlabel '$xlabel'\n";

    print GP "plot [-140:100] '$filehisto' using 1:4 title 'Real alignments' with boxes ls 3, '$filehistosh' using 1:4 title 'Random alignments' with boxes ls 1\n";
    close (GP);

    if ($seeplots == 1) { system ("gv -landscape -magstep -2 $outplot&\n"); }

}



sub is_above_cutoff {
    my ($cutoff_cod, $cutoff_rna, $type_ref, $codlod, $rnalod) = @_;

    my $above;
    my $sqrt2 = sqrt(2.0);
    my $log2 = 0.69314718056;

   if ($codlod <= $cutoff_cod && $codlod >= -$cutoff_cod &&
       $rnalod <= $cutoff_rna && $rnalod >= -$cutoff_rna) { 
	$$type_ref = 'RNA/COD/OTH'; $above = 0; 
    }
    elsif ($codlod < -$cutoff_cod &&
	   $rnalod <= $cutoff_rna && $rnalod >= -$cutoff_rna) { 
	$$type_ref = 'RNA/OTH'; $above = 0; 
    }
    elsif ($rnalod < -$cutoff_rna &&
	   $codlod <= $cutoff_cod && $codlod >= -$cutoff_cod) { 
	$$type_ref = 'COD/OTH'; $above = 0; 
    }
    elsif ($rnalod <= $codlod+$sqrt2*$cutoff_rna && $rnalod >= $codlod-$sqrt2*$cutoff_rna) { 
	$$type_ref = 'RNA/COD'; $above = 0; 
    }
    elsif ($rnalod < -$cutoff_rna && $codlod < -$cutoff_cod) { 
	$$type_ref = 'OTH';     $above = 1; 
    } 
    elsif ($codlod > $cutoff_cod && $rnalod < $codlod-$sqrt2*$cutoff_rna) { 
	$$type_ref = 'COD';     $above = 1; 
    } 
    elsif ($rnalod > $cutoff_rna && $codlod < $rnalod-$sqrt2*$cutoff_cod) { 
	$$type_ref = 'RNA';     $above = 1; 
    } 
    else { print "unknown type for (rnasc, codsc) = (", $rnalod, ", $codlod)\n"; }

    return $above;
}

sub is_above_cutoff_sigmoidal {
    my ($cutoff_cod, $cutoff_rna, $type_ref, $codlodsigm, $rnalodsigm) = @_;

    my $above;
  
    if    ($codlodsigm >= $cutoff_cod) { $$type_ref = 'COD'; $above = 1; }
    elsif ($rnalodsigm >= $cutoff_rna) { $$type_ref = 'RNA'; $above = 1; }
    else                               { $$type_ref = '';    $above = 0; }

    return $above;
}


sub init_evd_array {

    my ($Nid, $kid, $Nsc, $ksc, $evd_ref) = @_;

    my $dim_id = $Nid * $kid;
    my $dim_sc = $Nsc * $ksc;
    
    for (my $i = 0; $i <= $dim_id; $i++) { 
	for (my $sc = 0; $sc <= $dim_sc; $sc++) { 
	    $evd_ref->[$i][$sc] = 0.0;  
	}  
    }  
}

sub init_histo_array {

    my ($N, $k, $his_ref) = @_;

    my $dim = $N * $k;
    
    for (my $i=0; $i<=$dim; $i++) { $his_ref->[$i] = 0;  }
    
}

sub init_spread {
    
    my ($N, $k, $tspread_num_ref, $tspread_max_ref, $tspread_ave_ref, $tspread_std_ref) = @_;
    
    for (my $i = 0; $i <= $N*$k; $i++) { 
	
	$tspread_num_ref->[$i] = 0;
	
	$tspread_max_ref->[$i] = -999999.99;

	$tspread_ave_ref->[$i] = 0.0;
	$tspread_std_ref->[$i] = 0.0;
    }
    
}

sub max_2 {

    my $max_sc;

    my ($sc1, $sc2) = @_;

    $max_sc = ($sc2 > $sc1)? $sc2 : $sc1;

    return $max_sc;
}
sub max_3_score {

    my $max_sc;

    my ($othsc, $codsc, $rnasc) = @_;

    $max_sc = $othsc;

    if ($codsc > $max_sc) { $max_sc = $codsc; }
    if ($rnasc > $max_sc) { $max_sc = $rnasc; }

    return $max_sc;
}
sub min_2 {

    my $min_sc;

    my ($sc1, $sc2) = @_;

    $min_sc = ($sc2 < $sc1)? $sc2 : $sc1;

    return $min_sc;
}
sub min_3_score {

    my $min_sc;

    my ($othsc, $codsc, $rnasc) = @_;

    $min_sc = $othsc;

    if ($codsc < $min_sc) { $min_sc = $codsc; }
    if ($rnasc < $min_sc) { $min_sc = $rnasc; }

    return $min_sc;
}



sub parse_file {

    my ($outfile, $outplotcod, $outplotrna, $outplotidcod, $outplotidrna, $codschisto, $rnaschisto, $file, $key, 
	$max_num_win, $min_id, $max_id, 
	$Nid, $kid, $Ngap, $kgap, $Nmut, $kmut, $Nt, $kt, $Ngc, $kgc, $type_of_score,
	$len_ave_ref, $len_std_ref, $gc_ave_ref, $gc_std_ref, $n_ali_sc_ref,
	$count_total_ref, $count_ref, $count_above_ref, 
	$count_COD_ref, $count_COD_above_ref, $count_RNA_ref, $count_RNA_above_ref) = @_;

    my $is_qrna_12b = 0;

    my @othsc;
    my @codsc;
    my @rnasc;
    
    
    my $name1;
    my $name2;
    my $time;
    
    my $seq   = 0;
    my $n_win = 0;
    my $n_ali = 0;
    
    my $len;
    my $len_ave = 0.0;
    my $len_std = 0.0;

    my $id;
    my $gap;
    my $mut;
    my $gc=0;
    
    my $ll;

    my $line1;
    my $line2;
    
    my $othsc;
    my $codsc;
    my $rnasc;

    my $codlod;
    my $rnalod;

    my $othlodsigm;
    my $codlodsigm;
    my $rnalodsigm;

    my $display_cutoff_cod;
    my $display_cutoff_rna;

#init for ID histograms
    my $idhisto    = $file."_histo_id";
    my $idhistoCOD = $file."_histo_id_COD";
    my $idhistoRNA = $file."_histo_id_RNA";
    my @his_id;
    my @his_id_above;
    my @his_id_COD;
    my @his_id_RNA;
    init_histo_array ($Nid, $kid, \@his_id);
    init_histo_array ($Nid, $kid, \@his_id_above);
    init_histo_array ($Nid, $kid, \@his_id_COD);
    init_histo_array ($Nid, $kid, \@his_id_RNA);
    
#init for GAP histograms
    my $gaphisto    = $file."_histo_gap";
    my $gaphistoCOD = $file."_histo_gapCOD";
    my $gaphistoRNA = $file."_histo_gapRNA";
    my @his_gap;
    my @his_gap_COD;
    my @his_gap_RNA;
    init_histo_array ($Ngap, $kgap, \@his_gap);
    init_histo_array ($Ngap, $kgap, \@his_gap_COD);
    init_histo_array ($Ngap, $kgap, \@his_gap_RNA);
    
#init for MUT histograms
    my $muthisto    = $file."_histo_mut";
    my $muthistoCOD = $file."_histo_mut_COD";
    my $muthistoRNA = $file."_histo_mut_RNA";
    my @his_mut;
    my @his_mut_COD;
    my @his_mut_RNA;
    init_histo_array ($Nmut, $kmut, \@his_mut);
    init_histo_array ($Nmut, $kmut, \@his_mut_COD);
    init_histo_array ($Nmut, $kmut, \@his_mut_RNA);
    
#init for GC histograms
    my $gchisto    = $file."_histo_gc";
    my $gchistoCOD = $file."_histo_gc_COD";
    my $gchistoRNA = $file."_histo_gc_RNA";
    my @his_gc;
    my @his_gc_COD;
    my @his_gc_RNA;
    init_histo_array ($Ngc, $kgc, \@his_gc);
    init_histo_array ($Ngc, $kgc, \@his_gc_COD);
    init_histo_array ($Ngc, $kgc, \@his_gc_RNA);
    
#init for time histograms
    my $timehisto    = $file."_histo_time";
    my @his_time;
    my @his_time_above;
    init_histo_array ($Nt, $kt, \@his_time);
    init_histo_array ($Nt, $kt, \@his_time_above);
    
#init for score-cutoffs histograms
    my @his_codsc;
    my @his_rnasc;
    init_histo_array ($Nsc, $ksc, \@his_codsc);
    init_histo_array ($Nsc, $ksc, \@his_rnasc);
    my $score_ctf_cod = -12.0;
    my $score_ctf_rna = -2.0;
    my $n_ali_ctf     = 20;
    my $n_cod_ctf;
    my $n_rna_ctf;
    my $n_dis = 0;
    
#init for the SPREAD of log-odds as a function of the qrna time
    my @spread_cod_max;
    my @spread_cod_ave;
    my @spread_cod_std;
    my @num_cod_spread;
    init_spread($Nt, $kt, \@num_cod_spread,  \@spread_cod_max, \@spread_cod_ave, \@spread_cod_std);

    my @tspread_cod_max;
    my @tspread_cod_ave;
    my @tspread_cod_std;
    my @tnum_cod_spread;
    init_spread($Nt, $kt, \@tnum_cod_spread,  \@tspread_cod_max, \@tspread_cod_ave, \@tspread_cod_std);

    my @spread_rna_max;
    my @spread_rna_ave;
    my @spread_rna_std;
    my @num_rna_spread;
    init_spread($Nt, $kt, \@num_rna_spread,  \@spread_rna_max, \@spread_rna_ave, \@spread_rna_std);
    
    my @tspread_rna_max;
    my @tspread_rna_ave;
    my @tspread_rna_std;
    my @tnum_rna_spread;
    init_spread($Nt, $kt, \@tnum_rna_spread,  \@tspread_rna_max, \@tspread_rna_ave, \@tspread_rna_std);
   
#init for the SPREAD of log-odds as fuction of the ID
    my @spread_id_cod_max;
    my @spread_id_cod_ave;
    my @spread_id_cod_std;
    my @num_id_cod_spread;
    init_spread($Nid, $kid, \@num_id_cod_spread,  \@spread_id_cod_max, \@spread_id_cod_ave, \@spread_id_cod_std);

    my @tspread_id_cod_max;
    my @tspread_id_cod_ave;
    my @tspread_id_cod_std;
    my @tnum_id_cod_spread;
    init_spread($Nid, $kid, \@tnum_id_cod_spread,  \@tspread_id_cod_max, \@tspread_id_cod_ave, \@tspread_id_cod_std);

    my @spread_id_rna_max;
    my @spread_id_rna_ave;
    my @spread_id_rna_std;
    my @num_id_rna_spread;
    init_spread($Nid, $kid, \@num_id_rna_spread,  \@spread_id_rna_max, \@spread_id_rna_ave, \@spread_id_rna_std);
   
    my @tspread_id_rna_max;
    my @tspread_id_rna_ave;
    my @tspread_id_rna_std;
    my @tnum_id_rna_spread;
    init_spread($Nid, $kid, \@tnum_id_rna_spread,  \@tspread_id_rna_max, \@tspread_id_rna_ave, \@tspread_id_rna_std);

#init for different variables versus TIME
    my $time_outfile = $file."_time_plots";
    my @time_ll_num;
    my @time_ll_max;
    my @time_ll_ave;
    my @time_ll_std;
    init_spread($Nt, $kt, \@time_ll_num,  \@time_ll_max, \@time_ll_ave, \@time_ll_std);
    my @time_gc_num;
    my @time_gc_max;
    my @time_gc_ave;
    my @time_gc_std;
    init_spread($Nt, $kt, \@time_gc_num,  \@time_gc_max, \@time_gc_ave, \@time_gc_std);
    my @time_id_num;
    my @time_id_max;
    my @time_id_ave;
    my @time_id_std;
    init_spread($Nt, $kt, \@time_id_num,  \@time_id_max, \@time_id_ave, \@time_id_std);
    my @time_gap_num;
    my @time_gap_max;
    my @time_gap_ave;
    my @time_gap_std;
    init_spread($Nt, $kt, \@time_gap_num,  \@time_gap_max, \@time_gap_ave, \@time_gap_std);
    my @time_mut_num;
    my @time_mut_max;
    my @time_mut_ave;
    my @time_mut_std;
    init_spread($Nt, $kt, \@time_mut_num,  \@time_mut_max, \@time_mut_ave, \@time_mut_std);

#init for different variables versus ID
    my $id_outfile = $file."_id_plots";
    my @id_ll_num;
    my @id_ll_max;
    my @id_ll_ave;
    my @id_ll_std;
    init_spread($Nid, $kid, \@id_ll_num,  \@id_ll_max, \@id_ll_ave, \@id_ll_std);
    my @id_gc_num;
    my @id_gc_max;
    my @id_gc_ave;
    my @id_gc_std;
    init_spread($Nid, $kid, \@id_gc_num,  \@id_gc_max, \@id_gc_ave, \@id_gc_std);
    my @id_gap_num;
    my @id_gap_max;
    my @id_gap_ave;
    my @id_gap_std;
    init_spread($Nid, $kid, \@id_gap_num,  \@id_gap_max, \@id_gap_ave, \@id_gap_std);
    my @id_mut_num;
    my @id_mut_max;
    my @id_mut_ave;
    my @id_mut_std;
    init_spread($Nid, $kid, \@id_mut_num,  \@id_mut_max, \@id_mut_ave, \@id_mut_std);

       
    my $n_ali_sc = 0;


    #open (OUT,">$outfile") || die;
    
    open (FILE,"$file") || die;
    while (<FILE>) {
	
	if (/^\#\s+qrna\s+1.2b/) 
	{ 
	    $is_qrna_12b = 1;

	}elsif (/^>(\S+)/ && $seq == 0) 
	{ 
	    $time = -1;

	    $name1 = $1;
	    $line1 = $_;
	    
	    $seq = 1;
	    
	} elsif (/^>(\S+)/ && $seq == 1) 
	{ 
	    $name2 = $1;
	    $line2 = $_;
	    
	    $seq = 0;
	    $n_ali ++;
	    
	} 	
	elsif (/^Divergence time \(\S+\):\s+(\S+)/) {
	    $time = $1;
	}
	elsif (/^length alignment:\s+(\d+)\s+\(id=(\d+\.\d+)\)/) 
	{ 
	    
	    $len = $1+1;
	    $id  = $2;

	    if (/^length alignment:\s+(\d+)\s+\(id=(\S+)\)\s+\(mut=(\S+)\)\s+\(gap=(\S+)\)\(/) {
		$mut = $3;
		$gap = $4;
	    }
	    elsif (/^length alignment:\s+(\d+)\s+\(id=(\S+)\)\s+\(mut=(\S+)\)\s+\(gap=(\S+)\)/) {
		$mut = $3;
		$gap = $4;
	    }
	    else {
		$gap = 0;
		$mut = 0;
	    }
	    

	    $mut /= ($id+$mut);

	    $n_win ++; #actually is is the number of windows analyzed that we are counting here
	    
	    if ($max_num_win > 0  && $n_win > $max_num_win) { last; }
	    
	} elsif (/^posX:.+\(\S+\s(\S+)\s(\S+)\s\S+\)/) 
	{ 
	    $gc = $1 + $2; 
	    
	}  elsif (/^posY:.+\(\S+\s(\S+)\s(\S+)\s\S+\)/) 
	{ 
	    $gc += $1 + $2; $gc *= 50;
	    
	}  elsif (/^RNA\s+ends\s+=\s+(\d+)\s+(\d+)/) 
	{ 
	    my $x1 = $1;
	    my $x2 = $2;

	    if ($x1 > $x2) { $ll = $x1 - $x2; }
	    else           { $ll = $x2 - $x1; }


	}  elsif (/^RNA\s+ends \*\([\+\-]\)\s+=\s+\(\d+\.\.\[(\d+)\]\.\.\d+\)/) 
	{ 
	    $ll = $1;

	}  elsif (/^\s+OTH =\s+(\S+)\s+COD =\s+(\S+)\s+RNA =\s+(\S+)\s+$/) 
	{ 
	    $othsc = $1;
	    $codsc = $2;
	    $rnasc = $3;	
	    
	    if ($id > $min_id && $id <= $max_id && $n_ali < $max_n_ali) {
		$$count_total_ref ++;
		
		$gc_ave += $gc;
		$gc_std += $gc*$gc;

		$len_ave += $len;
		$len_std += $len*$len;

		fill_histo_array ($id,  $Nid,  $kid,  \@his_id); 
		fill_histo_array ($gap, $Ngap, $kgap, \@his_gap); 
		fill_histo_array ($mut, $Nmut, $kmut, \@his_mut); 
		fill_histo_array ($gc,  $Ngc,  $kgc,  \@his_gc); 
	
		if ($is_qrna_12b == 0) { 
		    fill_histo_array ($time, $Nt, $kt, \@his_time);
		    accumulate_averages ($Nt, $kt, $time, $id,  \@time_id_max,  \@time_id_ave,  \@time_id_std,  \@time_id_num);
		    accumulate_averages ($Nt, $kt, $time, $ll,  \@time_ll_max,  \@time_ll_ave,  \@time_ll_std,  \@time_ll_num);
		    accumulate_averages ($Nt, $kt, $time, $gc,  \@time_gc_max,  \@time_gc_ave,  \@time_gc_std,  \@time_gc_num);
		    accumulate_averages ($Nt, $kt, $time, $gap, \@time_gap_max, \@time_gap_ave, \@time_gap_std, \@time_gap_num);
		    accumulate_averages ($Nt, $kt, $time, $mut, \@time_mut_max, \@time_mut_ave, \@time_mut_std, \@time_mut_num);
		}
		
		accumulate_averages ($Nid, $kid, $id, $ll,  \@id_ll_max,  \@id_ll_ave,  \@id_ll_std,  \@id_ll_num);
		accumulate_averages ($Nid, $kid, $id, $gc,  \@id_gc_max,  \@id_gc_ave,  \@id_gc_std,  \@id_gc_num);
		accumulate_averages ($Nid, $kid, $id, $gap, \@id_gap_max, \@id_gap_ave, \@id_gap_std, \@id_gap_num);
		accumulate_averages ($Nid, $kid, $id, $mut, \@id_mut_max, \@id_mut_ave, \@id_mut_std, \@id_mut_num);
		
		$codlod = $codsc - $othsc;
		$rnalod = $rnasc - $othsc;
		
		$othlodsigm = - log(exp($codsc-$othsc) + exp($rnasc-$othsc));
		$codlodsigm = - log(exp($othsc-$codsc) + exp($rnasc-$codsc));
		$rnalodsigm = - log(exp($othsc-$rnasc) + exp($codsc-$rnasc));

		if ($othlodsigm < -500) { $othlodsigm = -1000; next; }
		if ($codlodsigm < -500) { $codlodsigm = -1000; next; }
		if ($rnalodsigm < -500) { $rnalodsigm = -1000; next; }

		if ($id >= $min_id_sc && $id <= $max_id_sc) {
		    $n_ali_sc++;

		    fill_histo_array ($codlodsigm+$shiftl, $Nlsc,  $klsc,  \@his_codsc); 
		    fill_histo_array ($rnalodsigm+$shiftl, $Nlsc,  $klsc,  \@his_rnasc); 
		    
		}

		if ($param_curve) {
		    $display_cutoff_cod = cutoff_for_id ("$param_curve", $id, $Nid, $kid);
		    $display_cutoff_rna = cutoff_for_id ("$param_curve", $id, $Nid, $kid);
		}
		
		elsif ($evalue) { 
		    $display_cutoff_cod = $evd_cutoff_cod[$id];
		    $display_cutoff_rna = $evd_cutoff_rna[$id]; 
		}
		
		else {
		    $display_cutoff_cod = $display_cutoff; 
		    $display_cutoff_rna = $display_cutoff; 
		}

		if ($type_of_score =~  /^simple$/) {

		    distribute_simple_scores($codlod, $rnalod,
					     $display_cutoff_cod, $display_cutoff_rna, $cutoff,
					     $Nid,  $kid,  $id,
					     $Ngap, $kgap, $gap,
					     $Nmut, $kmut, $mut,
					     $Nt,   $kt,   $time,
					     $Ngc,  $kgc,  $gc,
					     \@his_id_above, \@his_time_above, 
					     \@his_id_COD , \@his_gap_COD, \@his_mut_COD , \@his_gc_COD,
					     \@his_id_RNA , \@his_gap_RNA, \@his_mut_RNA , \@his_gc_RNA,
					     \@spread_cod_max,     \@spread_cod_ave,     \@spread_cod_std,     \@num_cod_spread,
					     \@spread_id_cod_max,  \@spread_id_cod_ave,  \@spread_id_cod_std,  \@num_id_cod_spread,
					     \@spread_rna_max,     \@spread_rna_ave,     \@spread_rna_std,     \@num_rna_spread,
					     \@spread_id_rna_max,  \@spread_id_rna_ave,  \@spread_id_rna_std,  \@num_id_rna_spread,
					     \@tspread_cod_max,    \@tspread_cod_ave,    \@tspread_cod_std,    \@tnum_cod_spread,
					     \@tspread_id_cod_max, \@tspread_id_cod_ave, \@tspread_id_cod_std, \@tnum_id_cod_spread,
					     \@tspread_rna_max,    \@tspread_rna_ave,    \@tspread_rna_std,    \@tnum_rna_spread,
					     \@tspread_id_rna_max, \@tspread_id_rna_ave, \@tspread_id_rna_std, \@tnum_id_rna_spread,
					     $count_ref, $count_above_ref, 
					     $count_COD_ref, $count_COD_above_ref, $count_RNA_ref, $count_RNA_above_ref);
		}
		
		else {

		    distribute_sigmoidal_scores($othlodsigm, $codlodsigm, $rnalodsigm,
						$display_cutoff_cod, $display_cutoff_rna, $cutoff,
						$Nid,  $kid,  $id,
						$Ngap, $kgap, $gap,
						$Nmut, $kmut, $mut,
						$Nt,   $kt,   $time,
						$Ngc,  $kgc,  $gc,
						\@his_id_above, \@his_time_above, 
						\@his_id_COD , \@his_gap_COD, \@his_mut_COD , \@his_gc_COD,
						\@his_id_RNA , \@his_gap_RNA, \@his_mut_RNA , \@his_gc_RNA,
						\@spread_cod_max,     \@spread_cod_ave,     \@spread_cod_std,     \@num_cod_spread,
						\@spread_id_cod_max,  \@spread_id_cod_ave,  \@spread_id_cod_std,  \@num_id_cod_spread,
						\@spread_rna_max,     \@spread_rna_ave,     \@spread_rna_std,     \@num_rna_spread,
						\@spread_id_rna_max,  \@spread_id_rna_ave,  \@spread_id_rna_std,  \@num_id_rna_spread,
						\@tspread_cod_max,    \@tspread_cod_ave,    \@tspread_cod_std,    \@tnum_cod_spread,
						\@tspread_id_cod_max, \@tspread_id_cod_ave, \@tspread_id_cod_std, \@tnum_id_cod_spread,
						\@tspread_rna_max,    \@tspread_rna_ave,    \@tspread_rna_std,    \@tnum_rna_spread,
						\@tspread_id_rna_max, \@tspread_id_rna_ave, \@tspread_id_rna_std, \@tnum_id_rna_spread,
						$count_ref, $count_above_ref, 
						$count_COD_ref, $count_COD_above_ref, $count_RNA_ref, $count_RNA_above_ref);
		}
	    }
	}
    }
    close (FILE);
    close (OUT);


    my $histofiles = 0;
    if ($is_qrna_12b == 0 && $histofiles == 1) { 
	calculate_averages ($Nt, $kt, \@time_ll_ave,  \@time_ll_std,  \@time_ll_num);
	calculate_averages ($Nt, $kt, \@time_gc_ave,  \@time_gc_std,  \@time_gc_num);
	calculate_averages ($Nt, $kt, \@time_id_ave,  \@time_id_std,  \@time_id_num);
	calculate_averages ($Nt, $kt, \@time_gap_ave, \@time_gap_std, \@time_gap_num);
	calculate_averages ($Nt, $kt, \@time_mut_ave, \@time_mut_std, \@time_mut_num);
	
	write_time_outfile ($time_outfile,  $Nt,  $kt, 
			    \@time_ll_ave,  \@time_ll_std,  \@time_ll_num,
			    \@time_gc_ave,  \@time_gc_std,  \@time_gc_num,
			    \@time_id_ave,  \@time_id_std,  \@time_id_num,
			    \@time_gap_ave, \@time_gap_std, \@time_gap_num,
			    \@time_mut_ave, \@time_mut_std, \@time_mut_num);
	
	plot_time_plots ($time_outfile);
    }
    
    if ($histofiles == 1) {
	calculate_averages ($Nid, $kid, \@id_ll_ave,  \@id_ll_std,  \@id_ll_num);
	calculate_averages ($Nid, $kid, \@id_gc_ave,  \@id_gc_std,  \@id_gc_num);
	calculate_averages ($Nid, $kid, \@id_gap_ave, \@id_gap_std, \@id_gap_num);
	calculate_averages ($Nid, $kid, \@id_mut_ave, \@id_mut_std, \@id_mut_num);
	
	write_id_outfile ($id_outfile,  $Nid,  $kid, 
			  \@id_ll_ave,  \@id_ll_std,  \@id_ll_num,
			  \@id_gc_ave,  \@id_gc_std,  \@id_gc_num,
			  \@id_gap_ave, \@id_gap_std, \@id_gap_num,
			  \@id_mut_ave, \@id_mut_std, \@id_mut_num); 
	
	
	plot_id_plots ($id_outfile);
    }

    if ($$count_total_ref > 0) { $len_ave /= $$count_total_ref; }
    else                       { $len_ave = 0.0;                }
    $len_std -= $len_ave*$len_ave*$$count_total_ref;
    if ($$count_total_ref > 0) { $gc_ave /= $$count_total_ref; }
    else                       { $gc_ave = 0.0;                }
    $gc_std -= $gc_ave*$gc_ave*$$count_total_ref;

    if    ($$count_total_ref >  1) { $len_std /= ($$count_total_ref-1); }
    else                           { $len_std = 0.0                     }
    if    ($$count_total_ref >  1) { $gc_std  /= ($$count_total_ref-1); }
    else                           { $gc_std  = 0.0                     }

    if ($len_std > -0.0001 && $len_std < 0.0) { $len_std = 0.0 }
    $len_std = sqrt($len_std);

    $len_ave = int $len_ave;
    $len_std = int $len_std;

    $gc_ave = int $gc_ave;
    $gc_std = int $gc_std;

    $$len_ave_ref = $len_ave;
    $$len_std_ref = $len_std;

    $$gc_ave_ref = $gc_ave;
    $$gc_std_ref = $gc_std;

    $$n_ali_sc_ref = $n_ali_sc;

     #if ($is_qrna_12b == 0) {
	#plot_spread ($outplotcod, "$key.COD", "QRNA Best-scoring divergence time", 
	#	     0, $max_time_plot, $Nt, $kt, 
	#	     $$count_COD_ref, $$count_above_ref, $$count_ref, 
	#	     \@his_time, \@his_time_above, 
        #            \@spread_cod_max,  \@spread_cod_ave,  \@spread_cod_std,  \@num_cod_spread,
        #            \@tspread_cod_max, \@tspread_cod_ave, \@tspread_cod_std, \@tnum_cod_spread,
	#	     \$max_x_cod, \$max_y_cod);
	#plot_spread ($outplotrna, "$key.RNS", "QRNA Best-scoring divergence time", 
	#	     0, $max_time_plot, $Nt, $kt, 
	#	     $$count_RNA_ref, $$count_above_ref, $$count_ref, 
	#	     \@his_time, \@his_time_above, 
        #            \@spread_rna_max,  \@spread_rna_ave,  \@spread_rna_std,  \@num_rna_spread,
        #            \@tspread_rna_max, \@tspread_rna_ave, \@tspread_rna_std, \@tnum_rna_spread,
	#	     \$max_x_rna, \$max_y_rna);  
  #
	#exp_fit ("$outplotcod", "$key.COD", "QRNA Best-scoring divergence time", $Nt,  $kt, 0, $max_time_plot, 0, $max_x_cod, $max_y_cod, 0, $divide_lodsc);
	#exp_fit ("$outplotrna", "$key.RNA", "QRNA Best-scoring divergence time", $Nt,  $kt, 0, $max_time_plot, 0, $max_x_rna, $max_y_rna, 0, $divide_lodsc);
   # }

    my $dosingleplots = 0;
    plot_spread ($outplotidcod, "$key.id.COD", "\% ID", $is_qrna_12b, $len_ave, $len_std,
		 100, $min_id_plot, $Nid, $kid, 
		 $$count_COD_ref, $$count_above_ref, $$count_total_ref, 
		 \@his_id, \@his_id_above, 
		 \@spread_id_cod_max,  \@spread_id_cod_ave,  \@spread_id_cod_std,  \@num_id_cod_spread,
		 \@tspread_id_cod_max, \@tspread_id_cod_ave, \@tspread_id_cod_std, \@tnum_id_cod_spread,
		 \$max_x_id_cod, \$max_y_id_cod, $dosingleplots);
    plot_spread ($outplotidrna, "$key.id.RNA", "\% ID", $is_qrna_12b, $len_ave, $len_std,
		 100, $min_id_plot, $Nid, $kid, 
		 $$count_RNA_ref, $$count_above_ref, $$count_total_ref, 
		 \@his_id, \@his_id_above, 
		 \@spread_id_rna_max,  \@spread_id_rna_ave,  \@spread_id_rna_std, \ @num_id_rna_spread,
		 \@tspread_id_rna_max, \@tspread_id_rna_ave, \@tspread_id_rna_std, \@tnum_id_rna_spread,
		 \$max_x_id_rna, \$max_y_id_rna, $dosingleplots);
    
    #exp_fit ("$outplotidcod", "$key.id.COD", "\% ID", $Nid, $kid, 100, $min_id_plot, 0, $max_x_id_cod, $max_y_id_cod, 1, $divide_lodsc);
    #exp_fit ("$outplotidrna", "$key.id.RNA", "\% ID", $Nid, $kid, 100, $min_id_plot, 0, $max_x_id_rna, $max_y_id_rna, 1, $divide_lodsc);

    if ($param_file) {
	fit_to_cutoff ("$outplotidcod", "$param_curve", "$key.id.COD", "\% ID", $Nid, $kid, $max_id_plot, $min_id_plot);
	fit_to_cutoff ("$outplotidrna", "$param_curve", "$key.id.RNA", "\% ID", $Nid, $kid, $max_id_plot, $min_id_plot);
    }



    my $max_t = 2.0;
      
    
#histograms
    #if ($is_qrna_12b == 0) {
#	my $time_title = "TIME ";
#	write_histo_file ("$timehisto",  $Nt,  $kt,  "TIME alignments (alignments = $n_win)",  $time_title,  $key, \@his_time, 0.0, 1.5);
   # }
    
    my $histograms = 0;
    if ($histograms == 1) {
	my $id_xlabel = "Percentage Identity";
	my $id_ylabel = "Number of windows";
	write_histo_file ("$idhisto",     $Nid,  $kid,  "\%ID TOTAL alignments (alignments = $n_ali -- windows = $n_win)", $id_xlabel, $id_ylabel,  $key, \@his_id,   , 30, 100);
	write_histo_file ("$idhistoCOD",  $Nid,  $kid,  "\%ID COD alignments (windows = $$count_COD_ref/$n_win)",          $id_xlabel, $id_ylabel,  $key, \@his_id_COD, 30, 100);
	write_histo_file ("$idhistoRNA",  $Nid,  $kid,  "\%ID RNA alignments (windows = $$count_RNA_ref/$n_win)",          $id_xlabel, $id_ylabel,  $key, \@his_id_RNA, 30, 100);
	
	my $gap_xlabel = "Percentage Gaps";
	my $gap_ylabel = "Number of windows";
	write_histo_file ("$gaphisto",    $Ngap, $kgap, "\%GAP TOTAL alignments (alignments = $n_ali -- windows = $n_win)", $gap_xlabel, $gap_ylabel, $key, \@his_gap,   , 0, 50);
	write_histo_file ("$gaphistoCOD", $Ngap, $kgap, "\%GAP COD alignments (windows = $$count_COD_ref/$n_win)",          $gap_xlabel, $gap_ylabel, $key, \@his_gap_COD, 0, 50);
	write_histo_file ("$gaphistoRNA", $Ngap, $kgap, "\%GAP RNA alignments (windows = $$count_RNA_ref/$n_win)",          $gap_xlabel, $gap_ylabel, $key, \@his_gap_RNA, 0, 50);
	
	my $mut_xlabel = "Percentage Mutations";
	my $mut_ylabel = "Number of windows";
	write_histo_file ("$muthisto",    $Nmut, $kmut, "\%MUT TOTAL alignments (alignments = $n_ali -- windows = $n_win)", $mut_xlabel, $mut_ylabel, $key, \@his_mut,   , 0, 100);
	write_histo_file ("$muthistoCOD", $Nmut, $kmut, "\%MUT COD alignments (windows = $$count_COD_ref/$n_win)",          $mut_xlabel, $mut_ylabel, $key, \@his_mut_COD, 0, 100);
	write_histo_file ("$muthistoRNA", $Nmut, $kmut, "\%MUT RNA alignments (windows = $$count_RNA_ref/$n_win)",          $mut_xlabel, $mut_ylabel, $key, \@his_mut_RNA, 0, 100);
	
	my $bc_xlabel = "%GC";
	my $bc_ylabel = "Number of windows";
	write_histo_file ("$gchisto",    $Ngc, $kgc, "\%BC TOTAL alignments (alignments  = $n_ali -- windows = $n_win)", $bc_xlabel, $bc_ylabel, $key, \@his_gc,   , 0, 100);
	write_histo_file ("$gchistoCOD", $Ngc, $kgc, "\%BC COD alignments (windows  = $$count_COD_ref/$n_win)",          $bc_xlabel, $bc_ylabel, $key, \@his_gc_COD, 0, 100);
	write_histo_file ("$gchistoRNA", $Ngc, $kgc, "\%BC RNA alignments (windows  = $$count_RNA_ref/$n_win)",          $bc_xlabel, $bc_ylabel, $key, \@his_gc_RNA, 0, 100);
	
	my $sc_ylabel = "Fraction of windows";
	my $sc_xlabel = "RNA_LODSCORE";
	write_histo_distr ("$rnaschisto", $Nlsc, $klsc, "PERCENTAGE ID [$min_id_sc,$max_id_sc] [ \# windows = $n_ali_sc ]", $sc_xlabel, $sc_ylabel, $key, \@his_rnasc, 0.8351, 0.60);
	$sc_xlabel = "COD_LODSCORE";
	write_histo_distr ("$codschisto", $Nlsc, $klsc, "PERCENTAGE ID[$min_id_sc,$max_id_sc] [ \# windows = $n_ali_sc ]", $sc_xlabel, $sc_ylabel, $key, \@his_codsc, 0.44, 0.9);
    }
    return $is_qrna_12b;
}

sub plot_spread {
    my ($outplot, $title, $xtitle, $is_qrna_12b, $len_ave, $len_std,
	$x0, $x1, $N, $k, 
	$count, $count_above, $count_total, 
	$his_ref, $his_above_ref, 
	$max_ref,  $ave_ref,  $std_ref,  $num_ref, 
	$tmax_ref, $tave_ref, $tstd_ref, $tnum_ref, 
	$max_x_ref, $max_y_ref,
	$doplot) = @_;
    
    my $max_x = -1.0;
    my $max_y = -99999.99;

    my $local_version = ($is_qrna_12b)? "qrna-1.2b" : "qrna-2.0"; 

    my $add = "<len> = $len_ave +/- $len_std";

    my $log_ave;
    my $dim = $N * $k;
    
    my $ext  = calculate_averages ($N, $k, $ave_ref,  $std_ref,  $num_ref);
    my $text = calculate_averages ($N, $k, $tave_ref, $tstd_ref, $tnum_ref);

    open (OUT,">$outplot") || die;
    for (my $i=0; $i<=$dim; $i++) { 
	
	if ($his_ref->[$i] > 0) {
	    
	    $log_ave = ($ave_ref->[$i] < $ave_ref->[0])? log($ave_ref->[0]-$ave_ref->[$i]) : -1.0;
	    
	    printf(OUT  "%.4f \t %d %d \t %d %.5f %.5f %.5f %.5f %.5f \t %d %.5f %.5f %.5f \n",
		   $i/$k,  
		   $his_ref->[$i],
		   $his_above_ref->[$i],
		   $num_ref->[$i], 
		   $max_ref->[$i], $ave_ref->[$i], $std_ref->[$i],
		   ($i/$k>0)?log($i/$k):-10, 
		   $log_ave,
		   $tnum_ref->[$i], 
		   $tmax_ref->[$i], $tave_ref->[$i], $tstd_ref->[$i]);
	    
	    if ($ave_ref->[$i] > $max_y) { $max_y = $ave_ref->[$i]; $max_x = $i/$k; }
	}
    }
    
    close (OUT);    
    
    $$max_x_ref = $max_x;
    $$max_y_ref = $max_y;

    if ($doplot) {
	open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
	print GP "set terminal postscript  default color solid 14\n";
	print GP "set linestyle 1 lt 1 lw 4\n";
	print GP "set linestyle 2 lt 2 lw 4\n";
	print GP "set linestyle 3  lt 3 lw 4\n";
	print GP "set linestyle 4 lt 4 lw 4\n";
	print GP "set linestyle 5 lt 5 lw 4\n";
	print GP "set linestyle 6 lt 6 lw 4\n";
	print GP "set linestyle 7 lt 7 lw 4\n";
	print GP "set linestyle 8 lt 8 lw 4\n";
	print GP "set linestyle 9 lt 9 lw 4\n";
	print GP "set linestyle 11 lt 1 lw 2 pt 1 ps 1.2\n";
	print GP "set linestyle 22 lt 2 lw 2 pt 2 ps 1.2\n";
	print GP "set linestyle 33 lt 3 lw 2 pt 3 ps 1.2\n";
	print GP "set linestyle 44 lt 4 lw 2 pt 4 ps 1.2\n";
	print GP "set linestyle 55 lt 5 lw 2 pt 5 ps 1.2\n";
	print GP "set linestyle 66 lt 6 lw 2 pt 6 ps 1.2\n";
	print GP "set linestyle 77 lt 7 lw 2 pt 7 ps 1.2\n";
	print GP "set linestyle 88 lt 8 lw 2 pt 8 ps 1.2\n";
	print GP "set linestyle 99 lt 9 lw 2 pt 9 ps 1.2\n";
	print GP "set output '$outplot.ps'\n";
	print GP "set title '$title'\n"; 
	print GP "set xlabel '$xtitle'\n";
	print GP "set ylabel 'QRNA-winner minimum-distance LODSCORE // $local_version'\n";
	
	print GP "plot [$x0:$x1]  '$outplot' using 1:2 title 'total_counts[$count_total]' with fsteps ls 9, '$outplot' using 1:3 title 'counts_above-$cutoff [$count_above]' with fsteps ls 2, '$outplot' using 1:4 title 'counts [$count/$count_above]' with boxes ls 3\n";
	print GP "plot [$x0:$x1]  5  title '$add' with lines ls 1, '$outplot' using 1:5 title 'max lodscore' ls 22 , '$outplot' using 1:6:7  title 'average lodscore [$count/$count_total]' with errorbars ls 33\n";
	print GP "plot [$x0:$x1]  5  title '$add' with lines ls 1, '$outplot' using 1:11 title 'max lodscore' ls 22 , '$outplot' using 1:12:13  title 'average lodscore' with errorbars ls 33\n";
	close(GP);
	
	#if ($seeplots == 1) { system ("gv -landscape -magstep -2 $outplot.ps&\n"); }
    }
    
}

sub plot_time_plots {

    my ($time_outplot) = @_;

    my $title = "$time_outplot";
    my $ytitle;
    my $xtitle = "TIME";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    print GP "set terminal postscript color solid 14\n";
    print GP "set linestyle 1 lt 1 lw 4\n";
    print GP "set linestyle 2 lt 2 lw 4\n";
    print GP "set linestyle 3  lt 3 lw 4\n";
    print GP "set linestyle 4 lt 4 lw 4\n";
    print GP "set linestyle 5 lt 5 lw 4\n";
    print GP "set linestyle 6 lt 6 lw 4\n";
    print GP "set linestyle 7 lt 7 lw 4\n";
    print GP "set linestyle 8 lt 8 lw 4\n";
    print GP "set linestyle 9 lt 9 lw 4\n";
    print GP "set linestyle 11 lt 1 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set linestyle 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 55 lt 5 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set linestyle 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set linestyle 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set linestyle 99 lt 9 lw 2 pt 9 ps 1.2\n";
    print GP "set output '$time_outplot.ps'\n";
    print GP "set title '$title'\n"; 
    print GP "set xlabel '$xtitle'\n";
    print GP "set function style linespoints\n";

    print GP "set ylabel '%LL'\n";
    print GP "plot '$time_outplot' using 1:3:4   with errorbars  ls 33\n";
    print GP "set ylabel '%GC'\n";
    print GP "plot '$time_outplot' using 1:6:7   with errorbars  ls 33\n";
    print GP "set ylabel '%ID'\n";
    print GP "plot '$time_outplot' using 1:9:10   with errorbars  ls 33\n";
    print GP "set ylabel '%GAP'\n";
    print GP "plot '$time_outplot' using 1:12:13  with errorbars  ls 33\n";
    print GP "set ylabel '%MUT'\n";
    print GP "plot '$time_outplot' using 1:15:16 with errorbars  ls 33\n";

    close(GP);
   
    if ($seeplots == 1) { system ("gv -landscape -magstep -2 $time_outplot.ps&\n"); }

}

sub plot_id_plots {

    my ($id_outplot) = @_;

    my $title = "$id_outplot";
    my $ytitle;
    my $xtitle = "\% ID";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    print GP "set terminal postscript color solid 14\n";
    print GP "set linestyle 1 lt 1 lw 4\n";
    print GP "set linestyle 2 lt 2 lw 4\n";
    print GP "set linestyle 3  lt 3 lw 4\n";
    print GP "set linestyle 4 lt 4 lw 4\n";
    print GP "set linestyle 5 lt 5 lw 4\n";
    print GP "set linestyle 6 lt 6 lw 4\n";
    print GP "set linestyle 7 lt 7 lw 4\n";
    print GP "set linestyle 8 lt 8 lw 4\n";
    print GP "set linestyle 9 lt 9 lw 4\n";
    print GP "set linestyle 11 lt 1 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set linestyle 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 55 lt 5 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set linestyle 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set linestyle 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set linestyle 99 lt 9 lw 2 pt 9 ps 1.2\n";
    print GP "set output '$id_outplot.ps'\n";
    print GP "set title '$title'\n"; 
    print GP "set xlabel '$xtitle'\n";
    print GP "set function style linespoints\n";

    print GP "set ylabel '%Length RNA call'\n";
    print GP "plot [$max_id_plot:$min_id_plot] '$id_outplot' using 1:3:4   with errorbars  ls 33\n";
    print GP "set ylabel '%GC'\n";
    print GP "plot [$max_id_plot:$min_id_plot] '$id_outplot' using 1:6:7   with errorbars  ls 33\n";
    print GP "set ylabel '%GAP'\n";
    print GP "plot [$max_id_plot:$min_id_plot] '$id_outplot' using 1:9:10  with errorbars  ls 33\n";
    print GP "set ylabel '%MUT'\n";
    print GP "plot [$max_id_plot:$min_id_plot] '$id_outplot' using 1:12:13 with errorbars  ls 33\n";

    close(GP);
   
    if ($seeplots == 1) { system ("gv -landscape -magstep -2 $id_outplot.ps&\n"); }

}

sub plot_together {

    my ($outplot, $outplotsh, $phase, $title, $xtitle, $type_of_score, 
	$max, $min, $x0, $x1, $y0, $y1, 
	$max_x, $max_y, $len_ave, $len_std,
	$count_phase, $count_phase_sh, $count_phase_above, $count_phase_sh_above, 
	$count_above, $count_sh_above, $count, $count_sh, $count_total, $countsh_total) = @_;

    my $fit;

    my $add = "<len> = $len_ave +/- $len_std        ID=[$max:$min]";

    my $key;
    if    ($param_curve) { $key = "above: $cutoff/curve";           }
    elsif ($evalue)      { $key = "above: $cutoff/Eval=$evalue";    }
    #else                 { $key = "above: $cutoff/$display_cutoff"; }
    else                 { $key = "above: $cutoff"; }

    my $evd_curve;
    if ($evalue) { 
	if    ($phase =~ /^COD$/) { $evd_curve = $evd_cutoff_curve_cod; }
	elsif ($phase =~ /^RNA$/) { $evd_curve = $evd_cutoff_curve_rna; }
    }
		   
    $max_y *= 3;

    if ($param_curve) {
	open (FIT,"$param_curve") || die;
	while(<FIT>) {
	    if    (/^\#fit1:(.+)/) { $fit  = $1; }
	    elsif (/^\#fit2:(.+)/) { $fit .= "--".$1; }
    }
	close (FIT);
    }
    
    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    print GP "set terminal postscript color solid 14\n";
    print GP "set linestyle 1 lt 1 lw 4\n";
    print GP "set linestyle 2 lt 2 lw 4\n";
    print GP "set linestyle 3  lt 3 lw 4\n";
    print GP "set linestyle 4 lt 4 lw 4\n";
    print GP "set linestyle 5 lt 5 lw 4\n";
    print GP "set linestyle 6 lt 6 lw 4\n";
    print GP "set linestyle 7 lt 7 lw 4\n";
    print GP "set linestyle 8 lt 8 lw 4\n";
    print GP "set linestyle 9 lt 9 lw 4\n";
    print GP "set linestyle 11 lt 1 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set linestyle 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 55 lt 5 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set linestyle 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set linestyle 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set linestyle 99 lt 9 lw 2 pt 9 ps 1.2\n";
    #print GP "set output '$outplot.ps'\n";
    print GP "set title '$title'\n"; 
    print GP "set xlabel '$xtitle'\n";
    print GP "set function style linespoints\n";

    print GP "set ylabel 'NUMBER OF WINDOWS // $version'\n";

    #print GP "set output '$outplot.1.ps'\n";
    print GP "set output '$outplot\_histo\_with\_sh.ps'\n";

    print GP "plot [$x0:$x1] '$outplot' using 1:2  title '$add   total_counts [$count_total]' with fsteps ls 2, '$outplot' using 1:4  title 'real $phase-phase_counts_$key [$count_phase_above//$count_total]' with fsteps ls 3, '$outplotsh' using 1:4  title 'shuffled $phase-phase_counts_$key [$count_phase_sh_above//$countsh_total]' with boxes ls 4\n";
    
    #print GP "set output '$outplot.2.ps'\n";

   #print GP "plot [$x0:$x1] '$outplot' using 1:2  title '$add   total_counts [$count_total]' with fsteps ls 2, '$outplot' using 1:3  title 'real counts_$key [$count_above/$count]' with fsteps ls 7, '$outplot' using 1:4  title 'real $phase-phase_counts_$key [$count_phase_above/$count_phase]' with fsteps ls 3\n";

     #print GP "plot [$x0:$x1] '$outplotsh' using 1:2  title '$add   total_counts [$countsh_total]' with fsteps ls 2, '$outplotsh' using 1:3  title 'shuffled counts_$key [$count_sh_above/$count_sh]' with fsteps ls 7, '$outplotsh' using 1:4  title 'shuffled $phase-phase_counts_$key [$count_phase_sh_above/$count_phase_sh]' with boxes ls 4\n";

    if ($type_of_score =~ /^simple$/) {
	print GP "set ylabel '$phase-winner minimum-distance $type_of_score LODSCORE // $version'\n";
    }
    else { 
	print GP "set ylabel '$phase-winner $type_of_score LODSCORE // $version'\n";
    }
 


    print GP "set output '$outplot\_scores\_with\_sh.ps'\n";

    if ($type_of_score =~ /^simple$/) {
	print GP "set ylabel '$phase minimum-distance $type_of_score LODSCORE // $version'\n";
    }
    else {
	print GP "set ylabel '$phase $type_of_score LODSCORE // $version'\n";
    }
   
    if ($y0 == -1 && $y1 == -1) {

    #print GP "set output '$outplot.3.ps'\n";

	print GP "plot [$x0:$x1] $cutoff  title '$add' with lines ls 2, '$outplot' using 1:12:13  title 'ave $phase lodscore $key [$count_phase_above//$count_total]' with errorbars  ls 33, '$outplotsh' using 1:12:13  title 'ave $phase shuffled_lodscore $key [$count_phase_sh_above//$countsh_total]' with errorbars ls 44\n";
	
    #print GP "set output '$outplot.4.ps'\n";
	if ($param_file) {
	    print GP "plot [$x0:$x1] $cutoff title '$add' with lines ls 2, '$outplot' using 1:12:13 title 'ave $phase lodscore_$key  [$count_phase_above//$count_total]' with errorbars  ls 33, '$outplotsh' using 1:12:13   title 'ave $phase shuffled_lodscore_$key [$count_phase_sh_above//$countsh_total]' with errorbars ls 44, '$param_curve' using 1:2  title '$fit' with lines ls 1\n";
	}
	elsif ($evalue) {
	    print GP "plot [$x0:$x1] $cutoff title '$add' with lines ls 2, '$outplot' using 1:12:13 title 'ave $phase lodscore_$key  [$count_phase_above//$count_total]' with errorbars  ls 33, '$outplotsh' using 1:12:13   title 'ave $phase shuffled_lodscore_$key [$count_phase_sh_above//$countsh_total]' with errorbars ls 44, '$evd_curve' using 1:2  title '$fit' with lines ls 1\n";
	}
	
	#print GP "plot [$x0:$x1] $cutoff  title '$add' with lines ls 2, '$outplot' using 1:11 title 'max $phase lodscore ' ls 55, '$outplot' using 1:12:13  title 'ave $phase lodscore $key [$count_phase_above//$count_total]' with errorbars ls 33,'$outplotsh' using 1:11 title 'max $phase shuffled_lodscore' ls 11, '$outplotsh' using 1:12:13  title 'ave $phase shuffled_lodscore $key [$count_phase_sh_above//$countsh_total]' with errorbars ls 44\n";

    }

    else {

    #print GP "set output '$outplot.3.ps'\n";
	print GP "plot [$x0:$x1] [$y0:$y1] $cutoff  title '$add' with lines ls 2, '$outplot' using 1:12:13  title 'ave $phase lodscore $key [$count_phase_above//$count_total]' with errorbars  ls 33, '$outplotsh' using 1:12:13  title 'ave $phase shuffled_lodscore $key [$count_phase_sh_above//$countsh_total]' with errorbars ls 44\n";
	
    #print GP "set output '$outplot.4.ps'\n";
	if ($param_file) {
	    print GP "plot [$x0:$x1]  [$y0:$y1] $cutoff title '$add' with lines ls 2, '$outplot' using 1:12:13 title 'ave $phase lodscore_$key  [$count_phase_above//$count_total]' with errorbars  ls 33, '$outplotsh' using 1:12:13   title 'ave $phase shuffled_lodscore_$key [$count_phase_sh_above//$countsh_total]' with errorbars ls 44, '$param_curve' using 1:2  title '$fit' with lines ls 1\n";
	#print GP "plot [$x0:$x1] [$y0:$y1] $cutoff title '$add' with lines ls 2, '$outplot' using 1:11 title 'max $phase lodscore ' ls 55, '$outplot' using 1:12:13  title 'ave $phase lodscore $key [$count_phase_above//$count_total]' with errorbars ls 33,'$outplotsh' using 1:11 title 'max $phase shuffled_lodscore' ls 11, '$outplotsh' using 1:12:13  title 'ave $phase shuffled_lodscore $key [$count_phase_sh_above//$countsh_total]' with errorbars ls 44, '$param_curve' using 1:2  title '$fit' with lines ls 1\n";
	}
	elsif ($evalue) {
	    print GP "plot [$x0:$x1] [$y0:$y1] $cutoff title '$add' with lines ls 2, '$outplot' using 1:12:13 title 'ave $phase lodscore_$key  [$count_phase_above//$count_total]' with errorbars  ls 33, '$outplotsh' using 1:12:13   title 'ave $phase shuffled_lodscore_$key [$count_phase_sh_above//$countsh_total]' with errorbars ls 44, '$evd_curve' using 1:2  title '$fit' with lines ls 1\n";
	#print GP "plot [$x0:$x1] [$y0:$y1] $cutoff title '$add' with lines ls 2, '$outplot' using 1:11 title 'max $phase lodscore ' ls 55, '$outplot' using 1:12:13  title 'ave $phase lodscore $key [$count_phase_above//$count_total]' with errorbars ls 33,'$outplotsh' using 1:11 title 'max $phase shuffled_lodscore' ls 11, '$outplotsh' using 1:12:13  title 'ave $phase shuffled_lodscore $key [$count_phase_sh_above//$countsh_total]' with errorbars ls 44, '$evd_curve' using 1:2  title '$fit' with lines ls 1\n";
	}
	
    }
    
    close(GP);
   

    if ($seeplots == 1) { 
	#system ("gv -landscape -magstep -2 $outplot.ps&\n"); 
	#system ("gv -landscape -magstep -2 $outplot.1.ps&\n"); 
	#system ("gv -landscape -magstep -2 $outplot.3.ps&\n"); 

	system ("gv -landscape -magstep -2 $outplot\_histo\_with\_sh.ps&\n"); 
	system ("gv -landscape -magstep -2 $outplot\_scores\_with\_sh.ps&\n"); 
    }

    system ("rm $outplot\n");
    system ("rm $outplotsh\n");
 
}
sub plot_select {

    my ($outplot, $outplotsh, $phase, $title, $xtitle, $type_of_score, 
	$max, $min, $x0, $x1, $y0, $y1, 
	$max_x, $max_y, $len_ave, $len_std,
	$count_phase, $count_phase_sh, $count_phase_above, $count_phase_sh_above, 
	$count_above, $count_sh_above, $count, $count_sh, $count_total, $countsh_total) = @_;

    my $fit;

    my $add = "<len> = $len_ave +/- $len_std        ID=[$max:$min]";

    my $key;
    $key = "above: $cutoff"; 

    
    $title = "813 SRP-RNA blastn alignments analized by QRNA ** RNA scores versus percentage similarity";
    $xtitle = "\% IDENTITY";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";
    print GP "set terminal postscript color solid 14\n";
    print GP "set linestyle 1 lt 1 lw 4\n";
    print GP "set linestyle 2 lt 2 lw 4\n";
    print GP "set linestyle 3  lt 3 lw 4\n";
    print GP "set linestyle 4 lt 4 lw 4\n";
    print GP "set linestyle 5 lt 5 lw 4\n";
    print GP "set linestyle 6 lt 6 lw 4\n";
    print GP "set linestyle 7 lt 7 lw 4\n";
    print GP "set linestyle 8 lt 8 lw 4\n";
    print GP "set linestyle 9 lt 9 lw 4\n";
    print GP "set linestyle 11 lt 1 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set linestyle 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set linestyle 55 lt 5 lw 2 pt 2 ps 1.2\n";
    print GP "set linestyle 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set linestyle 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set linestyle 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set linestyle 99 lt 9 lw 2 pt 9 ps 1.2\n";
    print GP "set output '$outplot.ps'\n";
    print GP "set title '$title'\n"; 
    print GP "set xlabel '$xtitle'\n";
    print GP "set function style linespoints\n";

    print GP "set ylabel 'NUMBER OF WINDOWS // $version'\n";

    if ($type_of_score =~ /^simple$/) {
	print GP "set ylabel '$phase-winner minimum-distance $type_of_score LODSCORE // $version'\n";
    }
    else { 
	print GP "set ylabel '$phase-winner $type_of_score LODSCORE // $version'\n";
    }

    
    
    print GP "set ylabel '$phase  LODSCORE // $version'\n";
   
 
	print GP "plot [$x0:$x1] $cutoff  title '$add' with lines ls 2, '$outplot' using 1:12:13  title 'ave $phase lodscore $key [$count_phase_above//$count_total]' with errorbars  ls 33, '$outplotsh' using 1:12:13  title 'ave $phase shuffled_lodscore $key [$count_phase_sh_above//$countsh_total]' with errorbars ls 44\n";
   
    close(GP);
   
    if ($seeplots == 1) { system ("gv -landscape -magstep -2 $outplot.ps&\n"); }
 
}


sub write_evd_array {

    my ($Nid, $kid, $Nsc, $ksc, $evd_ref) = @_;
    
    my $dim_id = $Nid * $kid;
    my $dim_sc = $Nsc * $ksc;


    #for (my $ i= 0; $i <= $dim_id; $i++) { for (my $sc = 0; $sc <= $dim_sc; $sc++) { print "<<ID $i SC $sc $evd_ref->[$i][$sc]\n";  }}

    for (my $ i= 0; $i <= $dim_id; $i++) {

	my $evd_id_ref = $evd_ref->[$i];

	my $add = 0;
	my $cum = 0;

	my @cum;

	for (my $sc = 0; $sc <= $dim_sc; $sc++) { $add += $evd_id_ref->[$sc];  $cum[$sc] = 0.0; }
	
	for (my $sc = 0; $sc <= $dim_sc; $sc++) { 
	    
	    $cum      += $evd_id_ref->[$sc]; 
	    $cum[$sc]  = $cum;
	    
	}
	for (my $sc = 0; $sc <= $dim_sc; $sc++) { 

	    if ($add > 0.0) { $evd_id_ref->[$sc] = 1.0 - $cum[$sc]/$add; }
	    else            { $evd_id_ref->[$sc] = 1.0;                  }                 
	}


    }
    #for (my $ i= 0; $i <= $dim_id; $i++) { for (my $sc = 0; $sc <= $dim_sc; $sc++) { print "ID $i SC $sc $evd_ref->[$i][$sc]\n";  }}


}

sub write_histo_file {

    my ($hisfile, $N, $k, $title, $xlabel, $ylabel, $key, $his_ref, $xl, $xr) = @_;
    
    my $dim = $N * $k;

    my $median = 0;
    my $mean;
    
    my $cum = 0;

    my $min_x = 0;
    my $max_x = 0;
    my $max_y = 0;
    my $add = 0;

    open (HIS,">$hisfile") || die;
    print HIS "#", $N, "\t", $k, "\t", $dim, "\n";
    print HIS "# $title\n";
    
    for (my $i=0; $i<=$dim; $i++) { $add += $his_ref->[$i]; if ($his_ref->[$i] > $max_y) { $max_y = $his_ref->[$i]; $mean = $i/$k;} }

    my $mid = int ($add/2) + 1;

    for (my $i=0; $i<=$dim; $i++) { 
	$cum += $his_ref->[$i]; 

	if ($cum <= $mid) { $median = $i/$k; } 

	if ($add > 0)  { if ($cum == $add) { $max_x = $N; } elsif ($cum/$add < 0.999999) { $max_x = $i/$k; } }
	if ($cum <= 0) { $min_x = $i/$k; }
	
    }

    $cum = 0;
    for (my $i=0; $i<=$dim; $i++) { 


	$cum += $his_ref->[$i]; 

	if ($i/$k >= $min_x && $i/$k <= $max_x) {
	    print  HIS $i/$k, "\t", $his_ref->[$i], "\t", $cum; 
	    	    
	    if ($add > 0) { print  HIS "\t", $his_ref->[$i]/$add, "\t", $cum/$add, "\n"; }
	    else          { print  HIS "\t 0.0 \t 0.0\n";                               } 	    
	}
    }
    
    print HIS "#max value = $max_y ";
    if ($add > 0) { print HIS "(",   int($max_y/$add*10000)/100,")\n"; }    else { print HIS "\n"; }
    print HIS "#median    = $median \n"; 

     close (HIS);
    
    gnuplot_histo($hisfile, $title, $xlabel, $ylabel, $key, $xl, $xr);
    
}

sub write_histo_distr {

    my ($hisfile, $N, $k, $title, $xlabel, $ylabel, $key, $his_ref, $lambda, $alpha) = @_;
    
    my $dim = $N * $k;

    my $median = 0;
    my $mean;
    
    my $cum = 0;

    my $min_x = 0;
    my $max_x = 0;
    my $max_y = 0;
    my $add = 0;

    open (HIS,">$hisfile") || die;
    print HIS "#", $N, "\t", $k, "\t", $dim, "\n";
    print HIS "# $title\n";

    for (my $i=0; $i<=$dim; $i++) { $add += $his_ref->[$i]; if ($his_ref->[$i] > $max_y) { $max_y = $his_ref->[$i]; $mean = ($i-$shiftl)/$k;} }

    my $mid = int ($add/2) + 1;

    for (my $i=0; $i<=$dim; $i++) { 
	$cum += $his_ref->[$i]; 

	if ($cum <= $mid) { $median = $i/$k; } 

	if ($add > 0) { if ($cum/$add < 0.999999) { $max_x = ($i-$shiftl)/$k; } }
	if ($cum <= 0)   { $min_x = ($i-$shiftl)/$k; }
	
    }

    my $sc;
    my $exp_sc;
    my $distr;
    my $distr_cum = 0;

    my $evalue = 0.01;
    my $sc_cutoff;

    $median -= $shiftl;

    $cum = 0;
    for (my $i=0; $i<=$dim; $i++) { 

	$sc = ($i-$shiftl-$mean)/$k;
	$exp_sc = $alpha*exp(-$sc*$lambda);

	if ($i > 0) { $distr = $lambda*$exp_sc*exp(-$exp_sc); $distr_cum += $distr; }

	if ($cum < $add*(1.0-$evalue)) { $sc_cutoff = ($i-$shiftl)/$k; }

	$cum += $his_ref->[$i]; 

	if (($i-$shiftl)/$k >= $min_x && ($i-$shiftl)/$k <= $max_x) {
	    print  HIS ($i-$shiftl)/$k, "\t", $his_ref->[$i], "\t", $cum; 
	    
	    
	    if ($add > 0) { print  HIS "\t", $his_ref->[$i]/$add, "\t", $cum/$add, " "; }
	    else          { print  HIS "\t 0.0 \t 0.0 ";                               } 
	    
	    print  HIS "\t", $distr, "\t", $distr_cum, "\n";
	}
	
    }
    
    print HIS "#Evalue = $evalue  sc_cutoff = $sc_cutoff \n";
    print HIS "#max value = $max_y ";
    if ($add > 0) { print HIS "(",   int($max_y/$add*10000)/100,")\n"; }    else { print HIS "\n"; }
    print HIS "#median    = $median \n"; 

     close (HIS);
    
    gnuplot_histo_distr($hisfile, $title, $xlabel, $ylabel, $key, $min_x, $max_x);
    
}

sub write_time_outfile {
    
    my ($outplot, $N, $k, 
	$ave_ll_ref,  $std_ll_ref,  $number_ll_ref, 
	$ave_gc_ref,  $std_gc_ref,  $number_gc_ref, 
	$ave_id_ref,  $std_id_ref,  $number_id_ref, 
	$ave_gap_ref, $std_gap_ref, $number_gap_ref, 
	$ave_mut_ref, $std_mut_ref, $number_mut_ref) = @_;
    
    my $dim = $N*$k;
    open (OUT,">$outplot") || die;
    
    for (my $i = 0; $i <= $dim; $i++) { 
	
	printf(OUT  "%.4f \t %d %.5f %.5f  \t %d %.5f %.5f \t %d %.5f %.5f \t %d %.5f %.5f \t %d %.5f %.5f \n",
	       $i/$k,  
	       $number_ll_ref->[$i],  $ave_ll_ref->[$i],  $std_ll_ref->[$i],
	       $number_gc_ref->[$i],  $ave_gc_ref->[$i],  $std_gc_ref->[$i],
	       $number_id_ref->[$i],  $ave_id_ref->[$i],  $std_id_ref->[$i],
	       $number_gap_ref->[$i], $ave_gap_ref->[$i], $std_gap_ref->[$i],
	       $number_mut_ref->[$i], $ave_mut_ref->[$i], $std_mut_ref->[$i]);
	
    }
    
    close (OUT);    
}

sub write_id_outfile {
    
    my ($outplot, $N, $k, 
	$ave_ll_ref,  $std_ll_ref,  $number_ll_ref, 
	$ave_gc_ref,  $std_gc_ref,  $number_gc_ref, 
	$ave_gap_ref, $std_gap_ref, $number_gap_ref, 
	$ave_mut_ref, $std_mut_ref, $number_mut_ref) = @_;
    
    my $dim = $N*$k;
    open (OUT,">$outplot") || die;
    
    for (my $i = 0; $i <= $dim; $i++) { 
	
	printf(OUT  "%.4f \t %d %.5f %.5f \t %d %.5f %.5f \t %d %.5f %.5f \t %d %.5f %.5f \n",
	       $i/$k,  
	       $number_ll_ref->[$i],  $ave_ll_ref->[$i],  $std_ll_ref->[$i],
	       $number_gc_ref->[$i],  $ave_gc_ref->[$i],  $std_gc_ref->[$i],
	       $number_gap_ref->[$i], $ave_gap_ref->[$i], $std_gap_ref->[$i],
	       $number_mut_ref->[$i], $ave_mut_ref->[$i], $std_mut_ref->[$i]);
	
    }
    
    close (OUT);    
}

