/********************************************************************************************************
 * QRNA - Comparative analysis of biological sequences 
 *         with pair hidden Markov models, pair stochastic context-free
 *        grammars, and probabilistic evolutionary  models.
 *       
 * Version 2.0.0 (JUN 2003)
 *
 * Copyright (C) 2000-2003 Howard Hughes Medical Institute/Washington University School of Medicine
 * All Rights Reserved
 * 
 *     This source code is distributed under the terms of the
 *     GNU General Public License. See the files COPYING and LICENSE
 *     for details.
 ***********************************************************************************************************/

/* evolve.h
 * ANSI prototypes for all external functions.
 * 
 */
#ifndef FUNCSH_INCLUDED
#define FUNCSH_INCLUDED

#include <stdio.h>

extern int     Check_Accuracy(double *vec, int L);
extern double *Condi_From_Joint(FILE *ofp, double *P, int L, int verbose);
extern void    ConditionalsEvolved(FILE *ofp, double *P, double *Q_0, int L, double tfactor, 
	        		   int pedantic, int verbose);
extern void    ConditionalsEvolved_2(FILE *ofp, double *Q, double *Q_0, double *R, int L, double tfactor, 
				     int pedantic, int verbose);
extern void    Joint2Joint(double *p_joint, double *q_nought, int L, double tfactor, 
			   int pedantic, int verbose);
extern double  TimeIdCorrelation (struct divergence_s div, double id);
extern void    TransitionsEvolvedLinear(FILE *ofp, double *q, double *q_0, double *r, double *r_diag, double *r_fix, int L, double tfactor, 
					int pedantic, int verbose);
extern void    TransitionsEvolved(FILE *ofp, double *q, double *q_0, double *q_infty, double *r_diag, int L, double tfactor, 
				  int pedantic, int verbose);
extern void    TransitionsDirectoryCosines(double *q, double *q_zero, double *q_infty, double *R_diag, int dim);
extern double *TransitionsExpVector(double *T, double *T_zero, double *T_infty, int dim);
extern double *TransitionsDiagVector(double *T, double *T_zero, double *T_rate, double *A_fix,  int dim);
extern double *TransitionsFixVector (double *T, double *T_zero, double *T_rate, double *A_diag, int dim);
extern double *TransitionsRateVector(double *T, double *T_zero, double *A_fix,  double *A_diag, int dim);

#endif /*FUNCSH_INCLUDED*/
