/********************************************************************************************************
 * QRNA - Comparative analysis of biological sequences 
 *         with pair hidden Markov models, pair stochastic context-free
 *        grammars, and probabilistic evolutionary  models.
 *       
 * Version 2.0.0 (JUN 2003)
 *
 * Copyright (C) 2000-2003 Howard Hughes Medical Institute/Washington University School of Medicine
 * All Rights Reserved
 * 
 *     This source code is distributed under the terms of the
 *     GNU General Public License. See the files COPYING and LICENSE
 *     for details.
 ***********************************************************************************************************/


/* globals.c
 *
 *
 * E. Rivas [St. Louis]
 * 
 * 9 april 1999.
 */
                                            
#include <stdio.h>

#include "funcs.h"
#include "globals.h"
#include "squid.h"
#include "structs.h"

#ifdef MEMDEBUG
#include "dbmalloc.h"
#endif

char Alphabet[]    = AMINO_ALPHABET;
char DNAAlphabet[] = DNA_ALPHABET;
char SSAlphabet[]  = "123456789abcdefghijklmnopqrstuvwxyz";

/* additions from RJ Klein rsearch code 22 JAN 03
 */
int   Alphabet_type  = kRNA;
int   Alphabet_size  = 4;
int   Alphabet_iupac = 17;

/**********************************************************************
 * Time/Id correlation function ID = 100 - a*time^b
 **********************************************************************/
struct divergence_s 
othdiv = { 
  65.0,  /* a */
  0.58    /* b */
};

struct divergence_s 
coddiv = { 
  0.0,  /* a */
  0.0   /* b */
};

struct divergence_s 
rnadiv = { 
  0.0,  /* a */
  0.0   /* b */
};

/**********************************************************************
 * Base Composition
 **********************************************************************/
struct singlep_s 
singlep = { 
  0.25, /*+ p[a]   +*/
  0.25, /*+ p[c]   +*/
  0.25  /*+ p[g]   +*/
}; 

/**********************************************************************
 * NULL-model
 **********************************************************************/
struct nullparam_s 
Nullparam = { 0.35 /*+ eta   +*/}; 

/**********************************************************************
 * OTHER-model
 **********************************************************************/
struct othparam_s 
OTHparam = {
  {0.80, /*+ FLN eta   +*/},
  {0.80, /*+ FJN eta   +*/},
  {0.80, /*+ FRN eta   +*/},

  0.09,  /*+ delta   +*/
  0.12,  /*+ epsilon +*/ 
  0.90,  /*+ eta     +*/ 
  0.005, /*+ gamma   +*/  
  0.09,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.88   /*+ xi      +*/
};

/* For t= 0,  
 *             - tau_0   < tau
 *             - eta_0   > eta but smaller than 1
 *             - xi_0    = 1
 *             - delta_0 = 0
 *             - kappa_0 = 0
 *
 *             - leave rest of parameter  unchanged
 */
struct othparam_s 
OTHparam_zero = {
  {1.00, /*+ FLN eta   +*/},
  {1.00, /*+ FJN eta   +*/},
  {1.00, /*+ FRN eta   +*/},

  0.00,   /*+ delta   +*/
  0.00,   /*+ epsilon +*/ 
  1.00,   /*+ eta     +*/ 
  0.00,   /*+ gamma   +*/  
  0.00,   /*+ kappa   +*/
  0.005,   /*+ tau     +*/  
  0.99    /*+ xi      +*/
};

/* For t= infty,  
 *             - tau   = 0.25
 *             - eta,  = 0.50
 *             - xi    = 0.50
 *             - delta = 0.25
 *             - epsilon = 0.25
 *             - kappa = 0.333
 *
 *             - leave rest of parameter  unchanged
 */
struct othparam_s 
OTHparam_infty = {
  {0.60, /*+ FLN eta   +*/},
  {0.60, /*+ FJN eta   +*/},
  {0.60, /*+ FRN eta   +*/},

  0.25,   /*+ delta   +*/
  0.30,   /*+ epsilon +*/ 
  0.50,   /*+ eta     +*/ 
  0.05,   /*+ gamma   +*/  
  0.33,   /*+ kappa   +*/
  0.005,   /*+ tau     +*/  
  0.70    /*+ xi      +*/
};

/* EmitsPerOTHState tells how many emissions there are for each state 
 * (1 if no emissions)
 */
int EmitsPerOTHState[OSTATES] = {
/* stFL   stB   stM   stX   stY   stE   stFJ   stFR     */
     1,    1,    16,   4,    4,    1,    1,     1
};

/* IdxTransOTHState tells where the transition indices begin for a given state.
 * (1 if no emissions)
 */
int IdxTransOTH[OSTATES]= {
/* stFL   stB   stM   stX   stY   stE   stFJ   stFR     */
    0,     2,    5,    9,    13,   17,   19,    20   
};

/* OConnects defines which states connect to each other in othermodel.
 * The order must be the same as in cfg.h, as this is indexed
 * by stB, stN, etc. #define's.
 */
int OConnects[OSTATES][OSTATES] = {
/* from:  to: stFL  stB   stM   stX   stY   stE  stFJ  stFR      */
/* stFL  */ {  0,    1,    0,    0,    0,    0,   0,    1},
/* stB   */ {  0,    0,    1,    1,    1,    0,   0,    0},
/* stM   */ {  0,    0,    1,    1,    1,    1,   0,    0},
/* stX   */ {  0,    0,    1,    1,    1,    1,   0,    0},
/* stY   */ {  0,    0,    1,    1,    1,    1,   0,    0},
/* stE   */ {  0,    0,    0,    0,    0,    0,   1,    1},
/* stFJ  */ {  0,    1,    0,    0,    0,    0,   0,    0},
/* stFR  */ {  0,    0,    0,    0,    0,    0,   0,    0}
};

/* The NAME arrays convertsinteger index values to strings
 */
char *ostNAME[OSTATES] = { 
  "FL", "B", "M", "X", "Y", "E", "FJ",  "FR"
};
char *otrNAME[OTRANS] = { 
  "FL->B", "FL->FR",
  "B-> M", "B-> X",  "B-> Y", 
  "M-> M", "M-> X",  "M-> Y",  "M-> E", 
  "X-> M", "X-> X",  "X-> Y",  "X-> E", 
  "Y-> M", "Y-> X",  "Y-> Y",  "Y-> E",  
  "E->FJ", "E->FR",
  "FJ->B", 
  "FR->FR"
};

int FromStateOTH[OTRANS] = { 
  stFL, stFL,
  stB, stB,  stB, 
  stM, stM,  stM,  stM, 
  stX, stX,  stX,  stX, 
  stY, stY,  stY,  stY,  
  stE, stE,
  stFJ, 
  stFR
};

int ToStateOTH[OTRANS] = { 
  stB, stFR,
  stM, stX,  stY, 
  stM, stX,  stY,  stE, 
  stM, stX,  stY,  stE, 
  stM, stX,  stY,  stE,  
  stFJ, stFR,
  stB, 
  stFR
};

/* TransPerOTHState tells how many non-zero transitions there are for each state 
 * (1 if no emissions)
 */
int TransPerOTHState[OSTATES]= {
/* stFR   stB   stM   stX   stY   stE   stFJ   stFR      */    
    2,     3,    4,    4,    4,    2,    1,     1         
};


/**********************************************************************
 * COD-model
 **********************************************************************/
struct codparam_s 
CODparam = {
 0.95,  /*+ phi = COB -> Cb   +*/
 0.01,  /*+ eta = Ce  -> COE  +*/
 0.00,  /*+ tau = Cb  -> Ce   +*/

/* parameters for transitions to codons. 
 * We allow codons of either (3,3) (3,4) (3,2),..., and (3,0) (2,0) (4,0) nts
 * paramters will be normalized later on.
 */
 /*+ xi:          3         4          2          0         +*/
 /*+ -------------------------------------------------------+*/
 /*+ 3 +*/{      0.98,     0.0001,         0.0001,        0.0001     ,
 /*+ 4 +*/       0.0001,    0.000000,      0.000000,      0.000000 ,
/*+ 2 +*/        0.0001,    0.000000,      0.000000,      0.000000,
 /*+ 0 +*/       0.0001,     0.000000,      0.000000,      0.000000  }
};

struct codparam_s 
CODparam_zero = {
 1.00,  /*+ phi = COB -> Cb   +*/
 0.001,  /*+ eta = Ce  -> COE  +*/
 0.00,  /*+ tau = Cb  -> Ce   +*/

/* parameters for transitions to codons. 
 * We allow codons of either (3,3) (3,4) (3,2),..., and (3,0) (2,0) (4,0) nts
 * paramters will be normalized later on.
 */
 /*+ xi:          3         4          2          0         +*/
 /*+ -------------------------------------------------------+*/
 /*+ 3 +*/{      1.00,     0.00,      0.00,      0.00      ,
 /*+ 4 +*/       0.00,     0.00,      0.00,      0.00      ,
 /*+ 2 +*/       0.00,     0.00,      0.00,      0.00      ,
 /*+ 0 +*/       0.00,     0.00,      0.00,      0.00      }
};

struct codparam_s 
CODparam_infty = {
 0.60,  /*+ phi = COB -> Cb   +*/
 0.05,  /*+ eta = Ce  -> COE  +*/
 0.00,  /*+ tau = Cb  -> Ce   +*/

/* parameters for transitions to codons. 
 * We allow codons of either (3,3) (3,4) (3,2),..., and (3,0) (2,0) (4,0) nts
 * paramters will be normalized later on.
 */
 /*+ xi:          3         4          2          0         +*/
 /*+ -------------------------------------------------------+*/
 /*+ 3 +*/{      0.94,      0.0003,      0.0003,      0.0003      ,
 /*+ 4 +*/       0.0003,      0.00,      0.00,      0.00      ,
 /*+ 2 +*/       0.0003,      0.00,      0.00,      0.00      ,
 /*+ 0 +*/       0.0003,      0.00,      0.00,      0.00      }
};

struct othparam_s 
COBparam = {
  {0.75, /*+ FLN eta   +*/},
  {0.75, /*+ FJN eta   +*/},
  {0.75, /*+ FRN eta   +*/},

  0.09,  /*+ delta   +*/
  0.12,  /*+ epsilon +*/ 
  0.90,  /*+ eta     +*/ 
  0.005, /*+ gamma   +*/  
  0.09,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.6   /*+ xi      +*/
};
struct othparam_s 
COBparam_zero = {
  {1.00, /*+ FLN eta   +*/},
  {1.00, /*+ FJN eta   +*/},
  {1.00, /*+ FRN eta   +*/},

  0.00,  /*+ delta   +*/
  0.00,  /*+ epsilon +*/ 
  1.00,  /*+ eta     +*/ 
  0.00,  /*+ gamma   +*/  
  0.00,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.65   /*+ xi      +*/
};

struct othparam_s 
COBparam_infty = {
  {0.50, /*+ FLN eta   +*/},
  {0.50, /*+ FJN eta   +*/},
  {0.50, /*+ FRN eta   +*/},

  0.25,   /*+ delta   +*/
  0.30,   /*+ epsilon +*/ 
  0.40,   /*+ eta     +*/ 
  0.03,   /*+ gamma   +*/  
  0.25,   /*+ kappa   +*/
  0.50,   /*+ tau     +*/  
  0.5    /*+ xi      +*/
};

struct othparam_s 
COJparam = {
  {0.75, /*+ FLN eta   +*/},
  {0.75, /*+ FJN eta   +*/},
  {0.75, /*+ FRN eta   +*/},

  0.09,  /*+ delta   +*/
  0.12,  /*+ epsilon +*/ 
  0.99,  /*+ eta     +*/ 
  0.005, /*+ gamma   +*/  
  0.09,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.000005   /*+ xi      +*/
};

/* COJ unchanged */
struct othparam_s 
COJparam_zero = {
  {1.00, /*+ FLN eta   +*/},
  {1.00, /*+ FJN eta   +*/},
  {1.00, /*+ FRN eta   +*/},

  0.00,  /*+ delta   +*/
  0.00,  /*+ epsilon +*/ 
  1.00,  /*+ eta     +*/ 
  0.00,  /*+ gamma   +*/  
  0.00,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.000001   /*+ xi      +*/
};

struct othparam_s 
COJparam_infty = {
  {0.50, /*+ FLN eta   +*/},
  {0.50, /*+ FJN eta   +*/},
  {0.50, /*+ FRN eta   +*/},

  0.25,  /*+ delta   +*/
  0.30,  /*+ epsilon +*/ 
  0.90,  /*+ eta     +*/ 
  0.05,  /*+ gamma   +*/  
  0.25,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.000008   /*+ xi      +*/
};

struct othparam_s 
COEparam = {
  {0.75, /*+ FLN eta   +*/},
  {0.75, /*+ FJN eta   +*/},
  {0.75, /*+ FRN eta   +*/},

  0.09,  /*+ delta   +*/
  0.12,  /*+ epsilon +*/ 
  0.90,  /*+ eta     +*/ 
  0.005, /*+ gamma   +*/  
  0.09,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.55   /*+ xi      +*/
};                
struct othparam_s 
COEparam_zero = {
  {1.00, /*+ FLN eta   +*/},
  {1.00, /*+ FJN eta   +*/},
  {1.00, /*+ FRN eta   +*/},

  0.00,  /*+ delta   +*/
  0.00,  /*+ epsilon +*/ 
  1.00,  /*+ eta     +*/ 
  0.00,  /*+ gamma   +*/  
  0.00,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.6   /*+ xi      +*/
};
                
struct othparam_s 
COEparam_infty = {
  {0.50, /*+ FLN eta   +*/},
  {0.50, /*+ FJN eta   +*/},
  {0.50, /*+ FRN eta   +*/},

  0.25,   /*+ delta   +*/
  0.30,   /*+ epsilon +*/ 
  0.40,   /*+ eta     +*/ 
  0.03,   /*+ gamma   +*/  
  0.25,   /*+ kappa   +*/
  0.005,   /*+ tau     +*/  
  0.5   /*+ xi      +*/
};

/* EmitsPerCODState tells how many emissions there are for each state 
 * (1 if no emissions)
 */
int EmitsPerCODState[CSTATES] = {
/* stCOB stCb stC33   stC34     stC32    stC43     stC44      stC42     stC23   stC24    stC22    */
    1,    1,   64*64,  64*256,   64*16,   256*64,   256*256,   256*16,   16*64,  16*256,  16*16,        
/* stC30  stC40   stC20  stC03   stC04    stC02  stCe  stCOJ  stCOE  */
    64,    256,    16,    64,     256,     16,    1,    1,     1 
};

/* IdxTransCODState tells where the transition indices begin for a given state.
 * (1 if no emissions)
 */
int IdxTransCOD[CSTATES] = {
/* stCOB stCb stC33  stC34   stC32  stC43   stC44    stC42   stC23  stC24   stC22    */
    0,    2,   18,    19,     20,    21,     22,      23,     24,    25,     26,        
/* stC30  stC40   stC20  stC03   stC04    stC02   stCe   stCOJ stCOE  */
    27,    28,     29,    30,     31,      32,     33,    35,   36   
};

/* The NAME arrays convert integer index values to strings
 */
char *cstNAME[CSTATES] = { 
  "COB", "Cb", 
  "C33", "C34", "C32", "C43", "C44", "C42", "C23", "C24", "C22", 
  "C30", "C40", "C20", "C03", "C04", "C02", 
  "Ce",  "COJ", "COE"
};
char *ctrNAME[CTRANS] = { 
  "COB->Cb", "COB->COE", 
  "Cb->C33", "Cb->C34", "Cb->C32", "Cb->C43", "Cb->C44", "Cb->C42", "Cb->C23", "Cb->C24", "Cb->C22", 
  "Cb->C30", "Cb->C40", "Cb->C20", "Cb->C03", "Cb->C04", "Cb->C02",
   "Cb->Ce",   
  "C33->Ce", "C34->Ce", "C32->Ce", "C43->Ce", "C44->Ce", "C42->Ce", "C23->Ce", "C24->Ce", "C22->Ce", 
  "C30->Ce", "C40->Ce", "C20->Ce", "C03->Ce", "C04->Ce", "C02->Ce",   
  "Ce->COJ", "Ce->COE", "COJ->Cb", "COE->COE" 
};
int FromStateCOD[CTRANS] = { 
  stCOB, stCOB, 
  stCb, stCb, stCb, stCb, stCb, stCb, stCb, stCb, stCb, 
  stCb, stCb, stCb, stCb, stCb, stCb,
  stCb,   
  stC33, stC34, stC32, stC43, stC44, stC42, stC23, stC24, stC22, 
  stC30, stC40, stC20, stC03, stC04, stC02,   
  stCe,  stCe, stCOJ, stCOE 
};
int ToStateCOD[CTRANS] = { 
  stCb, stCOE, 
  stC33, stC34, stC32, stC43, stC44, stC42, stC23, stC24, stC22, 
  stC30, stC40, stC20, stC03, stC04, stC02,
  stCe,   
  stCe,  stCe,  stCe,  stCe,  stCe,  stCe,  stCe,  stCe,  stCe, 
  stCe,  stCe,  stCe,  stCe,  stCe,  stCe,   
  stCOJ, stCOE, stCb, stCOE 
};

/* TransPerCODState tells how many non-zero transitions there are for each state 
 * (1 if no emissions)
 */
int TransPerCODState[CSTATES]= {
/* stCOB stCb stC33  stC34   stC32  stC43   stC44    stC42   stC23  stC24   stC22    */
    2,    16,  1,     1,      1,     1,      1,       1,      1,     1,      1,        
/* stC30  stC40   stC20  stC03   stC04    stC02   stCe stCOJ stCOE  */
    1,     1,      1,     1,      1,       1,      2,   1,    1
};


/**********************************************************************
 * RNA-model
 **********************************************************************/
struct rnaparam_s 
RNAparam = {
  0.999,  /*+ phi = ROB  -> RNA  +*/
  0.999,  /*+ eta = RNA  -> ROE  +*/
};

struct rnaparam_s 
RNAparam_zero = {
  1.00,  /*+ phi = ROB  -> RNA  +*/
  1.00,  /*+ eta = RNA  -> ROE  +*/
};

struct rnaparam_s 
RNAparam_infty = {
  0.995,  /*+ phi = ROB  -> RNA  +*/
  0.995,  /*+ eta = RNA  -> ROE  +*/
};

struct othparam_s 
Rloopparam = {
  {0.99, /*+ FLN eta   +*/},
  {0.99, /*+ FJN eta   +*/},
  {0.99, /*+ FRN eta   +*/},

  0.09,  /*+ delta   +*/
  0.12,  /*+ epsilon +*/ 
  0.90,  /*+ eta     +*/ 
  0.005, /*+ gamma   +*/  
  0.09,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.80   /*+ xi      +*/
};

struct othparam_s 
Rloopparam_zero = {
  {1.00, /*+ FLN eta   +*/},
  {1.00, /*+ FJN eta   +*/},
  {1.00, /*+ FRN eta   +*/},

  0.00,  /*+ delta   +*/
  0.00,  /*+ epsilon +*/ 
  1.00,  /*+ eta     +*/ 
  0.00,  /*+ gamma   +*/  
  0.00,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.85   /*+ xi      +*/
};

struct othparam_s 
Rloopparam_infty = {
  {0.96, /*+ FLN eta   +*/},
  {0.96, /*+ FJN eta   +*/},
  {0.96, /*+ FRN eta   +*/},

  0.25,  /*+ delta   +*/
  0.30,  /*+ epsilon +*/ 
  0.40,  /*+ eta     +*/ 
  0.05,  /*+ gamma   +*/  
  0.25,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.75   /*+ xi      +*/
};

struct othparam_s 
ROBparam = {
  {0.79, /*+ FLN eta   +*/},
  {0.79, /*+ FJN eta   +*/},
  {0.79, /*+ FRN eta   +*/},

  0.09,  /*+ delta   +*/
  0.12,  /*+ epsilon +*/ 
  0.90,  /*+ eta     +*/ 
  0.005, /*+ gamma   +*/  
  0.09,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.55   /*+ xi      +*/
};
struct othparam_s 
ROBparam_zero = {
  {1.00, /*+ FLN eta   +*/},
  {1.00, /*+ FJN eta   +*/},
  {1.00, /*+ FRN eta   +*/},

  0.00,  /*+ delta   +*/
  0.00,  /*+ epsilon +*/ 
  1.00,  /*+ eta     +*/ 
  0.00,  /*+ gamma   +*/  
  0.00,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.25   /*+ xi      +*/
};
struct othparam_s 
ROBparam_infty = {
  {0.60, /*+ FLN eta   +*/},
  {0.60, /*+ FJN eta   +*/},
  {0.60, /*+ FRN eta   +*/},

  0.25,    /*+ delta   +*/
  0.30,   /*+ epsilon +*/ 
  0.40,    /*+ eta     +*/ 
  0.05,    /*+ gamma   +*/  
  0.25,    /*+ kappa   +*/
  0.005,   /*+ tau     +*/  
  0.65     /*+ xi      +*/
};

struct othparam_s 
ROJparam = {
  {0.79, /*+ FLN eta   +*/},
  {0.79, /*+ FJN eta   +*/},
  {0.79, /*+ FRN eta   +*/},

  0.09,  /*+ delta   +*/
  0.12,  /*+ epsilon +*/ 
  0.90,  /*+ eta     +*/ 
  0.005, /*+ gamma   +*/  
  0.09,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.10   /*+ xi      +*/
};
struct othparam_s 
ROJparam_zero = {
  {1.00, /*+ FLN eta   +*/},
  {1.00, /*+ FJN eta   +*/},
  {1.00, /*+ FRN eta   +*/},

  0.00,  /*+ delta   +*/
  0.00,  /*+ epsilon +*/ 
  1.00,  /*+ eta     +*/ 
  0.00,  /*+ gamma   +*/  
  0.00,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.15   /*+ xi      +*/
};
struct othparam_s 
ROJparam_infty = {
  {0.60, /*+ FLN eta   +*/},
  {0.60, /*+ FJN eta   +*/},
  {0.60, /*+ FRN eta   +*/},

  0.25,  /*+ delta   +*/
  0.30,  /*+ epsilon +*/ 
  0.40,  /*+ eta     +*/ 
  0.05,  /*+ gamma   +*/  
  0.25,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.05   /*+ xi      +*/
};

struct othparam_s 
ROEparam = {
  {0.79, /*+ FLN eta   +*/},
  {0.79, /*+ FJN eta   +*/},
  {0.79, /*+ FRN eta   +*/},

  0.09,  /*+ delta   +*/
  0.12,  /*+ epsilon +*/ 
  0.90,  /*+ eta     +*/ 
  0.005, /*+ gamma   +*/  
  0.09,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.55   /*+ xi      +*/
};
struct othparam_s 
ROEparam_zero = {
  {1.00, /*+ FLN eta   +*/},
  {1.00, /*+ FJN eta   +*/},
  {1.00, /*+ FRN eta   +*/},

  0.00,  /*+ delta   +*/
  0.00,  /*+ epsilon +*/ 
  1.00,  /*+ eta     +*/ 
  0.00,  /*+ gamma   +*/  
  0.00,  /*+ kappa   +*/
  0.005,  /*+ tau     +*/  
  0.25   /*+ xi      +*/
};
struct othparam_s 
ROEparam_infty = {
  {0.60, /*+ FLN eta   +*/},
  {0.60, /*+ FJN eta   +*/},
  {0.60, /*+ FRN eta   +*/},

  0.25,    /*+ delta   +*/
  0.30,   /*+ epsilon +*/ 
  0.40,    /*+ eta     +*/ 
  0.05,    /*+ gamma   +*/  
  0.25,    /*+ kappa   +*/
  0.005,   /*+ tau     +*/  
  0.65     /*+ xi      +*/
};

/* IdxTransRNAState tells where the transition indices begin for a given state.
 * (1 if no emissions)
 */
int IdxTransRNA[RSTATES]= {
/* stROB  stRNA  stROJ  stROE    */
    0,     2,     4,     5    
};

/* The NAME arrays converts integer index values to strings
 */
char *rstNAME[RSTATES] = { 
  "ROB", "RNA", "ROJ", "ROE"
};
char *rtrNAME[RTRANS] = { 
  "ROB->RNA", "ROB->ROE", "RNA->ROJ", "RNA->ROE" , "ROJ->RNA" , "ROE->ROE" 
};
int FromStateRNA[RTRANS] = { 
  stROB, stROB, stRNA, stRNA, stROJ, stROE 
};
int ToStateRNA[RTRANS] = { 
  stRNA, stROE, stROJ, stROE, stRNA, stROE 
};

/* TransPerRNAState tells how many non-zero transitions there are for each state 
 * (1 if no emissions)
 */
int TransPerRNAState[RSTATES]= {
/* stROB  stRNA   stROJ   stROE       */
    2,     2,      1,      1  
};



/**********************************************************************
 * CFG_RNA-model
 **********************************************************************/
struct scfg_param_s 
SCFGparam = {
  { 0.10, /*+ V -->  IS1     +*/
    0.77, /*+ V -->  IS2s    +*/
    0.14, /*+ V -->  IS2b    +*/
    0.09, /*+ V -->  IS2i    +*/
    0.02  /*+ V -->  WB WB   +*/},

  { 0.35, /*+ W -->  a W     +*/
    0.35, /*+ W -->  W a     +*/
    0.30, /*+ W -->  a V b   +*/
    0.02   /*+ W -->  W W     +*/},

  { 0.35, /*+ WB --> a WB    +*/
    0.35, /*+ WB --> WB a    +*/
    0.30, /*+ WB --> a V b   +*/
    0.02  /*+ WB --> WB WB   +*/}
};

struct scfg_param_s 
SCFGparam_zero = {
  { 0.10, /*+ V -->  IS1     +*/
    0.77, /*+ V -->  IS2s    +*/
    0.14, /*+ V -->  IS2b    +*/
    0.09, /*+ V -->  IS2i    +*/
    0.02  /*+ V -->  WB WB   +*/},

  { 0.35, /*+ W -->  a W     +*/
    0.35, /*+ W -->  W a     +*/
    0.30, /*+ W -->  a V b   +*/
    0.02  /*+ W -->  W W     +*/},

  { 0.35, /*+ WB --> a WB    +*/
    0.35, /*+ WB --> WB a    +*/
    0.30, /*+ WB --> a V b   +*/
    0.02  /*+ WB --> WB WB   +*/}
};

struct scfg_param_s 
SCFGparam_infty = {
  { 0.10, /*+ V -->  IS1     +*/
    0.77, /*+ V -->  IS2s    +*/
    0.14, /*+ V -->  IS2b    +*/
    0.09, /*+ V -->  IS2i    +*/
    0.02  /*+ V -->  WB WB   +*/},

  { 0.35, /*+ W -->  a W     +*/
    0.35, /*+ W -->  W a     +*/
    0.30, /*+ W -->  a V b   +*/
    0.02  /*+ W -->  W W     +*/},

  { 0.35, /*+ WB --> a WB    +*/
    0.35, /*+ WB --> WB a    +*/
    0.30, /*+ WB --> a V b   +*/
    0.02  /*+ WB --> WB WB   +*/}
};


/* DpNodeidx tells where the node indices begin for a given state type.
 * This has to match up with idxP, etc. in cfg.h
 */
int DpNodeidx[NDPS] = {
/*  V     W     WB    IS1   IS2B  IS2I         */
    0,    6,    6,    11,   11,   11    
};


/* Idx tells how many states are included under each "state name"
 * (different from 1 for states that "remember" the previous emissions (ie V_{a,b}, VH_{a,b})
 */
int Idx[NDPS] = {
/*  V     W     WB     IS1   IS2B    IS2I     */
    16,   1,    1,     1,    1,      1       
};

/* NodesPerDp tells how many nodes there are for each RNA-dp state
 *  (it does not include the dummy node)
 */
int NodesPerDp[NDPS] = {
/*  V     W     WB    IS1         IS2B        IS2I        */
    5,    4,    4,    MAXRNALOOP, MAXRNALOOP, MAXRNALOOP 
};

char *stNAME[NDPS] = { 
  "V", "W", "WB", "IS1", "IS2B", "IS2I"
};

/* Ntrans tells how many transitions there are for each state
 */
int Ntrans[NDPS] = {
/*  V        W        WB       IS1       IS2B      IS2I     */
  NTRANSV, NTRANSW, NTRANSW, NTRANSIS, NTRANSIS, NTRANSIS
};


/* TransPerDp tells how many transitions there are for each dp state
 */
int TransPerDp[NDPS] = {
/*  V          W          WB         IS1         IS2B        IS2I     */
  NTRANSVst, NTRANSW-1, NTRANSW-1, NTRANSIS-1, NTRANSIS-1, NTRANSIS-1
};








